<?
$ScriptPath = realpath(dirname(__FILE__));
$LibPath = "$ScriptPath/unicornauth";
require_once("$LibPath/lib.console.php");
require_once("$LibPath/lib.strings.php");
require_once("$LibPath/lib.filesystem.php");
require_once("$LibPath/lib.xml.php");
require_once("$LibPath/lib.NSv2WebAPIClient.php");

class driverUtils extends AbstractAccessDriver 
{

    //This function get shares for the user logged in 
    //and return an array containig needed info.
    function getShares(){

        $Login = $_SESSION["AJXP_USER"]->id;
        $Password = $_SESSION["AJXP_USER"]->idp;
        if ($Password == null) {
            $authDriver = ConfService::getAuthDriverImpl();
            $data = $authDriver->listUsers();
            $Password = $data[$Login];
        }
        $Host = '127.0.0.1';
        $Port = 80;

        $TimeSkew = 0;

        $Client = new NSv2WebAPIClient($Host, $Port);
        $Client->SetAuthParameters($Login, $Password);

        // get system info, this is done without auth
        $Data = $Client->Call('/api/v2/system/general');
        $Hostname = $Data['general']['hostname'];
        $Version = $Data['general']['system_version'];

        // get user info
        $Data = $Client->Call('/api/v2/authentication/users/myself/shares?search_enabled=true&limit=-1');
        $listshare = array();

        $share_list = $Data['shares']['list']['share'];
        if (is_array($share_list[0])) {
            foreach ( $share_list  as $share){
                $name = $share['name'];
                $listshare[$name]["access"]   = $share['access'];
                $listshare[$name]["path"]     = $this->path."/".$name;
                $listshare[$name]["name"]     = $name;
                $listshare[$name]["login"]    = $_SESSION['AJXP_USER']->id;
                $listshare[$name]["chmod"]    = $this->repository->getOption("CHMOD_VALUE");
                $listshare[$name]["chown"]    = NULL;
                $listshare[$name]["external"] = $share['external']; 
            }
        }else{
            $name = $share_list['name'];
            $listshare[$name]["access"]   = $share_list['access'];
            $listshare[$name]["path"]     = $this->path."/".$name;
            $listshare[$name]["name"]     = $name;
            $listshare[$name]["login"]    = $_SESSION['AJXP_USER']->id;
            $listshare[$name]["chmod"]    = $this->repository->getOption("CHMOD_VALUE");
            $listshare[$name]["chown"]    = NULL;
            $listshare[$name]["external"] = $share_list['external']; 
        }
        return $listshare;
    }

    function isShared($dir, $list_share){
        $rez = False;
        if ($dir == "/"){
            $rez = True;
        }else{
            $dir = explode( "/", $dir);
            foreach($list_share as $share){
                //We simply check if dir root is in the name list 
                //of the shares available for that user
                if ($share['name'] == $dir[1]){
                    $rez = True;
                    break;
                }
            }
        }
        return $rez;
    }

    function isExternal($dir, $list_share){
        $rez = False;
        $dir = explode( "/", $dir);
        foreach($list_share as $share){
            //We simply check if dir root is in the name list 
            //of the shares available for that user
            if ($share['name'] == $dir[1]){
                $rez = $share['external'];
                break;
            }
        }
        return $rez;
    }

    function listShare($list_share){
        $rep = array();
        foreach($list_share as $share){
            //We simply check if dir root is in the name list 
            //of the shares available for that user
            $rep[$share['name']] = $share['name'];
        }
        return $rep;
    }

    //Check if user logged in has right to write on $dir
    //Right are full or read-only string in the db
    function haveRight($dir, $list_share, $action){
        $rez = False;
        $dir = explode( "/", $dir);
        //we look if we are on level 1 file tree which means : 
        // - shares so it should not be able to do anything to the structure tree !
        if (isSet($dir[1])){
            foreach($list_share as $share){
                if (($share['name'] == $dir[1]) && ($share['access'] == "full")){
                    $rez = True;
                    break;
                }
            }
        }
        return $rez;
    }

    // check that the depth of directory in the filesystem greater than 2
    function haveRightCopy($dirfile, $destfile, $action){
        if(isSet($dirfile[2]) || isSet($destfile[2])) return True;
        else return false;
    }

    function getChmod($path, $listshare){
        // Return chmod for filepath
        $path = str_replace("//", "/", $path);
        $dir = explode( "/", $path);
        if (isSet($dir[2])){
            foreach ($listshare as $share){
                if ( $share["name"] == $dir[2]) {
                    return $share["chmod"];
                }
            }
        }
    }

    function getChown($path, $listshare){
        // Return chmod for filepath
        $path = str_replace("//", "/", $path);
        $dir = explode( "/", $path);
        if (isSet($dir[2])){
            foreach ($listshare as $share){
                if ( $share["name"] == $dir[2]) {
                    return $share["chown"];
                }
            }
        }
    }

}
?>
