<?php
	require_once("$LibPath/lib.system.php");
	require_once("$LibPath/lib.strings.php");
	
	function FileSystem_CleanupDir($Path)
	{
		if(is_dir($Path))
			System_Exec("rm -rf $Path");
		System_Exec("mkdir -p $Path");
	}
	
	function FileSystem_ListFilesInPath($Path, $Extension = '')
	{
		$Files = array();
		
		$TrailMatch = '';
		if($Extension != '')
			$TrailMatch = ".$Extension";
		
		if(is_dir($Path))
		{
			$Dir = opendir($Path);
			if($Dir)
			{
				while(($File = readdir($Dir)) !== false)
				{
					if($File == '.' || $File == '..')
						continue;
					
					if($TrailMatch)
					{
						if(!String_EndsWith($File, $TrailMatch))
							continue;
					}
					
					if(is_file("$Path/$File"))
						$Files[] = $File;
				}
				closedir($Dir);
			}
		}
		sort($Files);
		return $Files;
	}
	
	function FileSystem_ListFiles($Path)
	{
		$lPath = strlen($Path);
		$Files = array();
		$Output = array();
		System_Exec("find $Path", $Output);
		$lOutput = count($Output);
		for($j=0;$j<$lOutput;$j++)
		{
			$Path = $Output[$j];
			if(is_dir($Path))
				continue;
			
			$File = substr($Path, $lPath + 1);
			
			$Files[] = $File;
		}
		sort($Files);
		return $Files;
	}
	
	function FileSystem_GetFileSize($Path)
	{
		if(file_exists($Path))
			return filesize($Path);
		return 0;
	}
	
	function FileSystem_GetTreeSizeKB($Path)
	{
		$Output = array();
		System_Exec("du -s $Path", $Output);
		$Size = (int)trim($Output[0]);
		return $Size;
	}
	
	function FileSystem_ReadTXTFile($Path)
	{
		if(is_file($Path))
			return file($Path, FILE_IGNORE_NEW_LINES);
		return FALSE;
	}
	
	function FileSystem_WriteTXTFile($Path, $Lines)
	{
		$Handle = fopen($Path, 'w');
		if(!$Handle)
		{
			Console_PrintError("error: opening file for writing: $Path");
			return 0;
		}
		
		$lLines = count($Lines);
		for($i=0;$i<$lLines;$i++)
			fwrite($Handle, $Lines[$i] . "\n");
		fclose($Handle);
		
		return 1;
	}
?>
