<?php
	require_once("$LibPath/lib.xml.php");
	
	function XML_DOMToArray($Xml)
	{
		if(!function_exists('_XML_DOMToArray_ProcessR'))
		{
			function _XML_DOMToArray_ProcessR($Node)
			{
				$Result = '';
				
				$Occurence = array();
				if($Node->hasChildNodes())
				{
					foreach($Node->childNodes as $child)
					{
						if(!isset($Occurence[$child->nodeName]))
							$Occurence[$child->nodeName] = 0;
						$Occurence[$child->nodeName]++;
					}
				}
				
				if($Node->nodeType == XML_TEXT_NODE)
				{
					$Result = html_entity_decode(htmlentities($Node->nodeValue, ENT_COMPAT, 'UTF-8'), ENT_COMPAT,'ISO-8859-15');
				}
				else
				{
					if($Node->hasChildNodes())
					{
						$ChildNodes = $Node->childNodes;
						
						for($i=0;$i<$ChildNodes->length; $i++)
						{
							$ChildNode = $ChildNodes->item($i);
							
							if($ChildNode->nodeName != '#text')
							{
								if($Occurence[$ChildNode->nodeName] > 1)
								{
									$Result[$ChildNode->nodeName][] = _XML_DOMToArray_ProcessR($ChildNode);
								}
								else
								{
									$Result[$ChildNode->nodeName] = _XML_DOMToArray_ProcessR($ChildNode);
								}
							}
							else if($ChildNode->nodeName == '#text')
							{
								$Text = trim(_XML_DOMToArray_ProcessR($ChildNode));
								if($Text != '')
									$Result = $Text;
							}
						}
					}
					
					if($Node->hasAttributes())
					{
						$Attributes = $Node->attributes;
						if($Attributes)
						{
							foreach($Attributes as $Key => $Attr)
								$Result['@' . $Attr->name] = $Attr->value;
						}
					}
				}
				
				return $Result;
			}
		}
		if(!is_string($Xml) || strlen($Xml) <= 0)
			return NULL;
		
		$DOMDoc = new DOMDocument();
		if(!$DOMDoc->loadXML($Xml))
		{
			Console_PrintError("error: DOMDocument::loadXML()");
			return NULL;
		}
		
		return _XML_DOMToArray_ProcessR($DOMDoc);
	}
?>