/**
 * @package info.ajaxplorer.plugins
 * 
 * Copyright 2007-2009 Charles du Jeu
 * This file is part of AjaXplorer.
 * The latest code can be found at http://www.ajaxplorer.info/
 * 
 * This program is published under the LGPL Gnu Lesser General Public License.
 * You should have received a copy of the license along with AjaXplorer.
 * 
 * The main conditions are as follow : 
 * You must conspicuously and appropriately publish on each copy distributed 
 * an appropriate copyright notice and disclaimer of warranty and keep intact 
 * all the notices that refer to this License and to the absence of any warranty; 
 * and give any other recipients of the Program a copy of the GNU Lesser General 
 * Public License along with the Program. 
 * 
 * If you modify your copy or copies of the library or any portion of it, you may 
 * distribute the resulting library provided you do so under the GNU Lesser 
 * General Public License. However, programs that link to the library may be 
 * licensed under terms of your choice, so long as the library itself can be changed. 
 * Any translation of the GNU Lesser General Public License must be accompanied by the 
 * GNU Lesser General Public License.
 * 
 * If you copy or distribute the program, you must accompany it with the complete 
 * corresponding machine-readable source code or with a written offer, valid for at 
 * least three years, to furnish the complete corresponding machine-readable source code. 
 * 
 * Any of the above conditions can be waived if you get permission from the copyright holder.
 * AjaXplorer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Description : The "online edition" manager, encapsulate the CodePress highlighter for some extensions.
 */
Class.create("OtherEditorChooser", AbstractEditor, {

	initialize: function($super, oFormObject)
	{
		this.element = oFormObject;
	},
	
	
	open : function($super, userSelection){
		$super(userSelection);
		var node = userSelection.getUniqueNode();
		var allEditors = this.findActiveEditors(node.getAjxpMime());
		var selector = this.element.down('#editor_selector');
		var even = false;
		allEditors.each(function(el){
			if(el.editorClass == "OtherEditorChooser") return;
			var elDiv = new Element('a', {
				href:'#', 
				className:(even?'even':''),
				style:"background-image:url('"+resolveImageSource(el.icon, '/images/actions/ICON_SIZE', 22)+"')"
				}).update(el.text + '<span>'+el.title+'</span>');
			even = !even;
			elDiv.editorData = el;
			elDiv.observe('click', this.selectEditor.bind(this));
			selector.insert(elDiv);
		}.bind(this) );
	},
	
	selectEditor : function(event){
        Event.stop(event);
		if(!event.target.editorData) return;
		ajaxplorer.loadEditorResources(event.target.editorData.resourcesManager);
		hideLightBox();
		modal.openEditorDialog(event.target.editorData);		
	},
	
	/**
	 * Find Editors that can handle a given mime type
	 * @param mime String
	 * @returns AbstractEditor[]
	 */
	findActiveEditors : function(mime){
		var editors = $A([]);
		var checkWrite = false;
		if(this.user != null && !this.user.canWrite()){
			checkWrite = true;
		}
		ajaxplorer.getActiveExtensionByType('editor').each(function(el){
			if(checkWrite && el.write) return;
			if(!el.openable) return;
			if(el.mimes.include(mime) || el.mimes.include('*')) return;
			editors.push(el);
		});
		if(editors.length && editors.length > 1){
			editors = editors.sortBy(function(ed){
				return ed.order||0;
			});
		}
		return editors;
	}
});
