<?

class driverUtils extends AbstractAccessDriver 
{
	//This function get shares for the user logged in and return an array containig needed info.
	function getShares()
	{
		$listshare = array();
		$isplug = 0;
		{
			$Lines = file('/proc/cpuinfo');
			$lLines = count($Lines);
			for($i=0;$i<$lLines;$i++)
			{
				$Line = trim($Lines[$i]);
				if(strstr($Line, 'plug'))
					$isplug = 1;
			}
		}
		
		if(!$isplug)
		{
			$name = 'MyShare';
			$listshare[$name]['access'] = 'full';
			$listshare[$name]['path'] = "/lacie/share/$name";
			$listshare[$name]['name'] = $name;
			$listshare[$name]['chmod'] = 0770;
			$listshare[$name]['chown'] = 1000;
			
			$name = 'OpenShare';
			$listshare[$name]['access'] = 'full';
			$listshare[$name]['path'] = "/lacie/share/$name";
			$listshare[$name]['name'] = $name;
			$listshare[$name]['chmod'] = 0777;
			$listshare[$name]['chown'] = 'nobody';
		}
		
		$dir = opendir('/lacie/share');
		while(false !== ($file = readdir($dir)))
		{
			if($file == '.' || $file == '..')
				continue;
			
			if(!$isplug && ($file == 'OpenShare' || $file == 'MyShare'))
				continue;
			
			$name = $file;
			
			$result = 0;
			system("mountpoint /lacie/share/$name > /dev/null 2>&1", $result);
			if($result != 0)
				continue;
			
			$listshare[$name]['access'] = 'full';
			$listshare[$name]['path'] = "/lacie/share/$name";
			$listshare[$name]['name'] = $name;
			$listshare[$name]['chmod'] = 0777;
			$listshare[$name]['chown'] = 'nobody';
		}
		closedir($dir); 
		
		// sort by name
		function share_cmp($share0, $share1)
		{
			$name0 = strtolower($share0['name']);
			$name1 = strtolower($share1['name']);
			return strcmp($name0, $name1);
		}
		
		if(count($listshare) > 0)
			usort($listshare, "share_cmp");
		
		return $listshare;
	}
	
	function isShared($dir, $list_share)
	{
		$rez = False;
		if ($dir == '/')
		{
			$rez = True;
		}
		else
		{
			$dir = explode('/', $dir);
			foreach($list_share as $share)
			{
				//We simply check if dir root is in the name list of the shares available for that user
				if ($share['name'] == $dir[1])
				{
					$rez = True;
					break;
				}
			}
		}
		return $rez;
	}

	function listShare($list_share)
	{
		$rep = array();
		foreach($list_share as $share)
		{
			//We simply check if dir root is in the name list of the shares available for that user
			$rep[$share['name']] = $share['name'];
		}
		return $rep;
	}

	//Check if user logged in has right to write on $dir
	//Right are full or read-only string in the db
	function haveRight($dir, $list_share, $action)
	{
		$rez = False;
		$dir = explode('/', $dir);
		//we look if we are on level 1 file tree which means : shares so it should not be able to do anything
		//to the structure tree !
		if(isSet($dir[1]))
		{
			foreach($list_share as $share)
			{
				if(($share['name'] == $dir[1]) && ($share['access'] == 'full'))
				{
					$rez = True;
					break;
				}
			}		
		}
		return $rez;
	}
	
	function haveRightCopy($dirfile, $destfile, $action)
	{
		if($action == 'copy' && isSet($dirfile[1]) || isSet($destfile[1]))
			return True;
		else if(isSet($dirfile[2]) || isSet($destfile[1]))
			return True;
		else
			return false;
	}
	
	function getChmod($path, $listshare)
	{
		// Return chmod for filepath
		$path = str_replace('//', '/', $path);
		$dir = explode('/', $path);
		if(isSet($dir[3]))
		{
			foreach($listshare as $share)
			{
				if($share['name'] == $dir[3])
					return $share['chmod'];
			}
		}
	}
	
	function getChown($path, $listshare)
	{
		// Return chmod for filepath
		$path = str_replace('//', '/', $path);
		$dir = explode('/', $path);
		if(isSet($dir[3]))
		{
			foreach($listshare as $share)
			{
				if($share['name'] == $dir[3])
					return $share['chown'];
			}
		}
	}
}
?>
