<?php
	require_once("$LibPath/lib.console.php");
	
	class NSv2WebAPIClient
	{
		private $Host = '';
		private $Port = 0;
		private $Protocol = '';
		
		private $Login = '';
		private $Password = '';
		
		private $TimeSkew = 0;
		
		function __construct($Host, $Port=80, $Protocol='http')
		{
			$this->Host = $Host;
			$this->Port = $Port;
			$this->Protocol = $Protocol;
		}
		
		function SetAuthParameters($Login, $Password)
		{
			$this->Login = $Login;
			$this->Password = $Password;
		}
		
		private static function HTTPRequest($Host, $Port, $Path, $Login, $Password, $Protocol='http', $TimeSkew=0)
		{
			$URL = $Protocol . '://' . $Host . $Path;
			$Time = time();
			//$Time = 1301471000;	// uncomment to force skew negociation
			$Time += $TimeSkew;
			$DateStr = gmdate("D, d M Y H:i:s", $Time) . ' GMT';
			//$PasswordSHA1 = sha1($Password); // uncomment if your password is given in clear
			$PasswordSHA1 = $Password;
			$Payload = "GET $Path\n" . "Date: $DateStr\n";
			$Signature = base64_encode(hash_hmac('sha1', $Payload, $PasswordSHA1, true));
			$LoginB64 = base64_encode($Login);
			$Opts = array(
				'http' => array(
					'ignore_errors' => 1,
					'method' => 'GET',
					'header' => "Authentication: HMAC-SHA1-DATE $LoginB64:$Signature\r\n" .
								"Content-Type: text/plain; charset=utf-8\r\n" .
								"DATE-AUTH: $DateStr\r\n"
				)
			);
			$Context = stream_context_create($Opts);
			
			$Handle = fopen($URL, 'rb', false, $Context);
			if(!$Handle)
			{
				Console_PrintError("Error: fopen($URL)");
				return NULL;
			}
			$Content = @stream_get_contents($Handle);
			$Meta = @stream_get_meta_data($Handle);
			fclose($Handle);
			
			$ReplyHeaders = $Meta['wrapper_data'];
			$HTTPCode = 0;
			if(count($ReplyHeaders) > 0)
				list($HTTPCode) = sscanf($ReplyHeaders[0], '%*s %d %*s');
			
			return array($HTTPCode, $Content);
		}
		
		function Call($Path)
		{
			$nTry = 0;
			while(1)
			{
				if($nTry > 5)
				{
					Console_PrintError("Max number of tries reached");
					return NULL;
				}
				
				list($HTTPCode, $Content) = $this->HTTPRequest($this->Host, $this->Port, $Path, $this->Login, $this->Password, $this->Protocol, $this->TimeSkew);
				if(!$HTTPCode)
					return NULL;
				
				if($HTTPCode == 401)
				{
					$Data = XML_DOMToArray($Content);
					$ErrorCode = $Data['error']['code'];
					if(strcasecmp($ErrorCode, 'TimeIsSkewed') == 0)
					{
						$ErrorMsg = $Data['error']['message'];
						list($iSkewDays, $iSkewSecs) = sscanf($ErrorMsg, 'Time is skewed by %d days and %d seconds');
						$iSkew = $iSkewDays * 86400 + $iSkewSecs;
						Console_Print("Warning: skewed time: $iSkew s");
						$this->TimeSkew = $iSkew;
						$nTry++;
						continue;
					}
					else
					{
						Console_PrintError("Unhandled error: <$HTTPCode, $ErrorCode>");
						return NULL;
					}
				}
				else if($HTTPCode != 200)
				{
					$Data = XML_DOMToArray($Content);
					$ErrorCode = $Data['error']['code'];
					Console_PrintError("Unhandled error: <$HTTPCode, $ErrorCode>");
					return NULL;
				}
				
				return XML_DOMToArray($Content);
			}
		}
	}
?>
