<?php
/**
 * @package info.ajaxplorer
 * 
 * Copyright 2007-2009 Cyril Russo
 * This file is part of AjaXplorer.
 * The latest code can be found at http://www.ajaxplorer.info/
 * 
 * This program is published under the LGPL Gnu Lesser General Public License.
 * You should have received a copy of the license along with AjaXplorer.
 * 
 * The main conditions are as follow : 
 * You must conspicuously and appropriately publish on each copy distributed 
 * an appropriate copyright notice and disclaimer of warranty and keep intact 
 * all the notices that refer to this License and to the absence of any warranty; 
 * and give any other recipients of the Program a copy of the GNU Lesser General 
 * Public License along with the Program. 
 * 
 * If you modify your copy or copies of the library or any portion of it, you may 
 * distribute the resulting library provided you do so under the GNU Lesser 
 * General Public License. However, programs that link to the library may be 
 * licensed under terms of your choice, so long as the library itself can be changed. 
 * Any translation of the GNU Lesser General Public License must be accompanied by the 
 * GNU Lesser General Public License.
 * 
 * If you copy or distribute the program, you must accompany it with the complete 
 * corresponding machine-readable source code or with a written offer, valid for at 
 * least three years, to furnish the complete corresponding machine-readable source code. 
 * 
 * Any of the above conditions can be waived if you get permission from the copyright holder.
 * AjaXplorer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Description : Interface between AjaXplorer and external software. Handle with care!
  * Take care when using this file. It can't be included anywhere, as it's doing global scope pollution.
  *    Typically, this is used as glue code from your CMS frontend and AJXP code. 
  *    This example file switches sessions (close CMS session, open AJXP session, modify AJXP's 
  *    session value so the users actions are performed as if they were done locally by AJXP, and then 
  *    reopen your CMS session).
  *    This is typically used by Wordpress as the plugin mechanism is hook based.
  *
  *    The idea is: this script is require()'d by the CMS script. 
 */
 
define('AJXP_EXEC','true'); 
  
//We check that it's a post and that we have everything (should only come from unicorn)
if ( ! empty($_POST['action']) ){
	    if (!isSet($CURRENTPATH)) $CURRENTPATH=dirname(__FILE__);
		require_once("$CURRENTPATH/../../server/classes/class.AJXP_Logger.php");
		require_once("$CURRENTPATH/../../server/classes/class.AJXP_Plugin.php");
		require_once("$CURRENTPATH/../../server/classes/class.AJXP_PluginsService.php");
		require_once("$CURRENTPATH/../../server/classes/class.AJXP_Utils.php");
		require_once("$CURRENTPATH/../../server/classes/class.Repository.php");
		require_once("$CURRENTPATH/../../server/classes/class.AbstractAccessDriver.php");
		if (!class_exists("SessionSwitcher")) require_once("$CURRENTPATH/sessionSwitcher.php");
		require_once("$CURRENTPATH/../../server/classes/class.ConfService.php");
		require_once("$CURRENTPATH/../../server/classes/class.AuthService.php");    
		include_once("$CURRENTPATH/../../server/conf/base.conf.php");
		$pServ = AJXP_PluginsService::getInstance();
		$pServ->loadPluginsRegistry("$CURRENTPATH/../../plugins", "$CURRENTPATH/../../server/conf");

		define ("CLIENT_RESOURCES_FOLDER", "client");
		ConfService::init("$CURRENTPATH/../../server/conf/conf.php"); 
		$plugins = ConfService::getConf("PLUGINS");
		require_once("$CURRENTPATH/../../plugins/conf.".$plugins["CONF_DRIVER"]["NAME"]."/class.AJXP_User.php");

		$plugInAction = $_POST['action'];

		switch($plugInAction){
		case 'login':
    		if ( !empty($_POST['username']) && !empty($_POST['password']) ){
    			$username = $_POST['username'];
        		$pwd = $_POST['password'];
        		if ( !empty($_POST['language']) )
    	        	$lang = $_POST['language'];
        	}else{
        	    echo "Wrong Username/Password.";
        	    break;
        	}
		
			$newSession = new SessionSwitcher("AjaXplorer");
			$result = AuthService::logUser($username, $pwd, true) == 1;
			$userObject = AuthService::getLoggedUser();
			AuthService::updateAdminRights($userObject);
			$userObject->save();			
			$_SESSION["AJXP_USER"]->prefs["lang"] = $lang;
			$_SESSION["AJXP_USER"]->idp = $pwd;
			echo "AjaXplorer"." ".session_id()." "."PHPSESSID"." ".md5($username.":".$pwd.":ajxp"); 
			// Return the cookie_nameSPACEcookie_value to unicorn
		break;
		case 'logout':
		    $newSession = new SessionSwitcher("AjaXplorer");
    		global $_SESSION;
    		$_SESSION = array();
		break;
		default:
	    	echo "wrong action";
		}
}

?>
