<?php
/**
 * @package info.ajaxplorer
 * 
 * Copyright 2007-2009 Charles du Jeu
 * This file is part of AjaXplorer.
 * The latest code can be found at http://www.ajaxplorer.info/
 * 
 * This program is published under the LGPL Gnu Lesser General Public License.
 * You should have received a copy of the license along with AjaXplorer.
 * 
 * The main conditions are as follow : 
 * You must conspicuously and appropriately publish on each copy distributed 
 * an appropriate copyright notice and disclaimer of warranty and keep intact 
 * all the notices that refer to this License and to the absence of any warranty; 
 * and give any other recipients of the Program a copy of the GNU Lesser General 
 * Public License along with the Program. 
 * 
 * If you modify your copy or copies of the library or any portion of it, you may 
 * distribute the resulting library provided you do so under the GNU Lesser 
 * General Public License. However, programs that link to the library may be 
 * licensed under terms of your choice, so long as the library itself can be changed. 
 * Any translation of the GNU Lesser General Public License must be accompanied by the 
 * GNU Lesser General Public License.
 * 
 * If you copy or distribute the program, you must accompany it with the complete 
 * corresponding machine-readable source code or with a written offer, valid for at 
 * least three years, to furnish the complete corresponding machine-readable source code. 
 * 
 * Any of the above conditions can be waived if you get permission from the copyright holder.
 * AjaXplorer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Description : Serialized Files implementation of AbstractConfDriver
 */
defined('AJXP_EXEC') or die( 'Access not allowed');

require_once(INSTALL_PATH."/server/classes/class.AbstractConfDriver.php");
class lacieunicornConfDriver extends AbstractConfDriver {
		
	var $repoSerialFile;
	var $usersSerialDir;
	var $rolesSerialFile;
	
	var $aliasesIndexFile;
	
	function init($options){
		parent::init($options);
	}
	function listRoles(){
		return null;
	}
	
	function saveRoles($roles){
	    //just here to please ajxp
	}
	
	function listRepositories(){
	    //nothing
	}
	
	function getRepositoryById($repositoryId){
	    //nothing
	}

	function getRepositoryByAlias($repositorySlug){
		//nothing
	}	
	
	function saveRepository($repositoryObject, $update = false){
	    //nothing
	}
	
	function deleteRepository($repositoryId){
		//nothing
	}
	
	function countAdminUsers(){
	     // Ajaxplorer need at list 1 admin. As admin features of ajaxplorer are not used we can retrun a fix value set to 1. On Nas side there is at least 1 admin
	     // This function is only called in bootSequence method to know if ajaplorer need to create an "admin" account. In our case, we want to bypass this check.
 	     return 1;
	}	
	// SAVE / EDIT / CREATE / DELETE USER OBJECT (except password)
	/**
	 * Instantiate the right class
	 *
	 * @param AbstractAjxpUser $userId
	 */
	function instantiateAbstractUserImpl($userId){
		return new AJXP_User($userId, $this);
	}
	
	
	function getUserClassFileName(){
		return INSTALL_PATH."/plugins/conf.lacieunicorn/class.AJXP_User.php";
	}

}
?>
