#include "tree.h"

#include "debug.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <dirent.h>
#include <sys/stat.h>
#include <errno.h>

int directory_recursive_process (const char *directory, path_process directory_process, path_process file_process) {
	int file_error_code, error_code = 0 ;
	DIR *directory_handle ;
	struct dirent *file_info1 ;
	struct stat file_info2 ;
	int is_directory ;
	char *path = NULL ;
	int directory_length, file_length, path_size = 0 ;

	/* open directory or symlink to a directory */
	dprintf (E_DBG, "OPEN   %s", directory) ;
	directory_handle = opendir (directory) ;
	if (directory_handle == NULL) {
		perror ("opendir") ;
		return -1 ;
	}

	if (directory_process != NULL)
		error_code |= directory_process (directory) ;

	directory_length = strlen (directory) + 2 ; /* directory + '/' + '\0' */
	while ((file_info1 = readdir (directory_handle)) != NULL) {
		/* get full path */
		file_length = strlen (file_info1->d_name) ;
		if (path_size < directory_length + file_length) {
			/* increase by an arbitrary number to minimize future reallocs */
			path_size = directory_length + file_length + 50 ;
			path = (char *) realloc (path, path_size) ;
			if (path == NULL) {
				perror ("realloc path") ;
				error_code = -1 ;
				goto end ;
			}
		}
		sprintf (path, "%s/%s", directory, file_info1->d_name) ;
		/* check path */
		file_error_code = lstat (path, &file_info2) ;
		if (file_error_code != 0) {
			DPRINTF(E_LOG,L_SCAN,"lstat failed on %s: %s\n", path, strerror(errno)) ;
			/*perror ("lstat") ;*/
			continue ;
		}
		error_code |= file_error_code ;
		is_directory = S_ISDIR (file_info2.st_mode) ;
		/* recurse if it is a real subdirectory, neither . nor .. nor symlink */
		if (is_directory) {
			if (strcmp (file_info1->d_name, ".") == 0)
				continue ;
			if (strcmp (file_info1->d_name, "..") == 0)
				continue ;
			error_code |= directory_recursive_process (path, directory_process, file_process) ;
		} else if (file_process != NULL)
			error_code |= file_process (path) ;
	}
end :
	if (path != NULL)
		free (path) ;
	error_code |= closedir (directory_handle) ;
	return error_code ;
}
