/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/common-boardenv.c
 *
 * Copyright (c) 2009 LaCie
 *	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/kernel.h>
#include <linux/bitops.h>
#include <linux/gpio.h>
#include "boardEnv/mvBoardEnvLib.h"

extern  MV_BOARD_INFO *boardInfoTbl[];
#define BOARD_INFO(boardId)	boardInfoTbl[boardId - BOARD_ID_BASE]

/*
 * Some output GPIO's are already "well" initialized by the boot loader
 * (example: hard disk power pins). This function manage to protect this GPIO
 * values through the Marvell board initialization (see mvBoardEnvInit()).
 */
void __init gpio_out_keep_values(u32 boardId, u32 *gpio_out_keep_map)
{
	u32 *mv_gppOutVal;
	int i, bit, pin, pin_max, val;

	for(i = 0; i < GPIO_MAX / 32 + 1; i++) {

		if (!gpio_out_keep_map[i])
			continue;

		pin_max = min(GPIO_MAX - 32 * i, 32);

		/* FIXME: 2 GPIO banks limit */
		mv_gppOutVal = i ? &BOARD_INFO(boardId)->gppOutValHigh :
				   &BOARD_INFO(boardId)->gppOutValLow;

		for_each_bit(bit, (unsigned long *) &gpio_out_keep_map[i],
			     pin_max) {

			pin = bit + i * 32;

			/* Output configured ? */
			if (readl(GPIO_IO_CONF(pin)) & (1 << bit))
				continue;

			/* Keep output value */
			val = (readl(GPIO_OUT(pin)) >> bit) & 1;
			if (val)
				set_bit(bit, (unsigned long *) mv_gppOutVal);
			else
				clear_bit(bit, (unsigned long *) mv_gppOutVal);

			pr_debug("Keep GPIO setting: gpio=%d dir=out val=%d\n",
				 pin, val);
		}
	}
}
