/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/common-boardenv.h
 *
 * Copyright (c) 2009 LaCie
 *	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARCH_FEROCEON_KW_COMMON_BOARDENV_H
#define __ARCH_FEROCEON_KW_COMMON_BOARDENV_H

/*
 * MPP configuration
 */

/*
 * MPP[0-7] definition:
 * 0: SPI-CS                    - 0x2
 * 1: SPI-MOSI                  - 0x2
 * 2: SPI-CLK                   - 0x2
 * 3: SPI-MISO                  - 0x2
 * 4: Nand Flash IO             - 0x1
 * 5: Nand Flash IO             - 0x1
 * 6: System Reset              - 0x1
 * 7: GPIO                      - 0x0
 */
#define COMMON_MPP0_7		0x01112222

/*
 * MPP[8-15] definition:
 * 8:  tw data (i2c)            - 0x1
 * 9:  tw clock (i2c)           - 0x1
 * 10: UART0-TX                 - 0x3
 * 11: UART0-RX                 - 0x3
 * 12: GPIO                     - 0x0
 * 13: GPIO                     - 0x0
 * 14: GPIO                     - 0x0
 * 15: GPIO                     - 0x0
 */
#define COMMON_MPP8_15		0x00003311

/*
 * MPP[16-23] definition:
 * 16: GPIO                     - 0x0
 * 17: GPIO                     - 0x0
 * 18: Nand Flash IO            - 0x1
 * 19: Nand Flash IO            - 0x1
 * 20: LED SATA1 activity       - 0x5
 * 21: LED SATA0 activity       - 0x5
 * 22: GPIO                     - 0x0
 * 23: GPIO                     - 0x0
 */
#define COMMON_MPP16_23		0x00551100

/*
 * MPP[24-31] definition:
 * 24: GPIO                     - 0x0
 * 25: GPIO                     - 0x0
 * 26: GPIO                     - 0x0
 * 27: GPIO                     - 0x0
 * 28: GPIO                     - 0x0
 * 29: GPIO                     - 0x0
 * 30: GPIO                     - 0x0
 * 31: GPIO                     - 0x0
 */
#define COMMON_MPP24_31		0x00000000

/*
 * MPP[32-39] definition:
 * 32: GPIO                     - 0x0
 * 33: GPIO                     - 0x0
 * 34: GPIO                     - 0x0
 * 35: GPIO                     - 0x0
 * 36: GPIO                     - 0x0
 * 37: GPIO                     - 0x0
 * 38: GPIO                     - 0x0
 * 39: GPIO                     - 0x0
 */
#define COMMON_MPP32_39		0x00000000

/*
 * MPP[40-47] definition:
 * 40: GPIO                     - 0x0
 * 41: GPIO                     - 0x0
 * 42: GPIO                     - 0x0
 * 43: GPIO                     - 0x0
 * 44: GPIO                     - 0x0
 * 45: GPIO                     - 0x0
 * 46: GPIO                     - 0x0
 * 47: GPIO                     - 0x0
 */
#define COMMON_MPP40_47		0x00000000

/*
 * MPP[48-55] definition:
 * 48: GPIO                     - 0x0
 * 49: GPIO                     - 0x0
 */
#define COMMON_MPP48_55		0x00000000

/*
 * GPIO configuration
 */

/*
 * Startup values ("/" means set when low)
 * Bit low enable GPIO port output
 *
 * GPIO data out enable control register (low):
 * 0:  0x0 -                          16: 0x0 - out (power on hd1)
 * 1:  0x0 -                          17: 0x0 - out (power on hd2)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 - out (LED for HD2 SATA activity)
 * 5:  0x0 -                          21: 0x0 - out (LED for HD1 SATA activity)
 * 6:  0x0 -                          22: 0x0 - out (fan speed bit 0)
 * 7:  0x0 - out (fan speed bit 1     23: 0x0 - out (fan power)
 *                or board power off) 24: 0x0 - out (USB mode select)
 * 8:  0x0 -                          25: 0x1 - /in (fan fail)
 * 9:  0x0 -                          26: 0x1 - in  (USB device VBus)
 * 10: 0x0 -                          27: 0x1 - in  (SW INIT)
 * 11: 0x0 -                          28: 0x0 - out (USB VBUS-out)
 * 12: 0x0 - out (fail led)           29: 0x0 - out (slow LED or EXT-ALE)
 * 13: 0x1 - in  (SWON)               30: 0x0 - out (LED command)
 * 14: 0x1 - in  (USB fuse)           31: 0x0 - out (board power off)
 * 15: 0x1 - in  (SWOFF)
 *
 * bitmap: 0000 1110 0000 0000 1110 0000 0000 0000
 *
 */
#define COMMON_GPIO_OE_LOW	0x0E00E000

/*
 * GPIO data out register (low):
 *
 * Startup values ("/" means set when low)
 *
 * 0:  0x0 -                          16: 0x1 - on  (power on hd1)
 * 1:  0x0 -                          17: 0x1 - on  (power on hd2)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 - /on (LED for HD2 SATA activity)
 * 5:  0x0 -                          21: 0x0 - /on (LED for HD1 SATA activity)
 * 6:  0x0 -                          22: 0x0 - /off (fan speed bit 0)
 * 7:  0x0 - /off (fan speed bit 1)   23: 0x0 - off (fan power)
 *         or off (board power off)   24: 0x0 - off (USB mode select)
 * 8:  0x0 -                          25: 0x0 -
 * 9:  0x0 -                          26: 0x0 -
 * 10: 0x0 -                          27: 0x0 -
 * 11: 0x0 -                          28: 0x1 - on  (USB VBUS-out)
 * 12: 0x0 - off (fail led)           29: 0x0 - off (slow LED or EXT-ALE)
 * 13: 0x0 -                          30: 0x0 - on  (LED command)
 * 14: 0x0 -                          31: 0x0 - off (board power off)
 * 15: 0x0 -
 *
 * bitmap: 0101 0000 0000 0011 0000 0000 0000 0000
 *
 */
#define COMMON_GPIO_OE_VAL_LOW	0x10030000

/*
 * GPIO data out enable control register (high):
 * Bit low enable GPIO port output
 *
 * 32: 0x1 - in  (push button state)  48: 0x0 - out (extention addr 1)
 * 33: 0x0 - out (fan speed bit 2)    49: 0x0 - out (extention addr 2)
 * 34: 0x1 - in  (front power button) 50: 0x0 -
 * 35: 0x0 - out (inhibit power off)  51: 0x0 -
 * 36: 0x1 - in  (PRES1)              52: 0x0 -
 * 37: 0x1 - in  (PRES2)              53: 0x0 -
 * 38: 0x1 - in  (PRES3)              54: 0x0 -
 * 39: 0x1 - in  (PRES4)              55: 0x0 -
 * 40: 0x1 - in  (PRES-eSATA)         56: 0x0 -
 * 41: 0x0 - out (power on hd3)       57: 0x0 -
 * 42: 0x0 - out (power on hd4)       58: 0x0 -
 * 43: 0x0 - out (power on hd5)       59: 0x0 -
 * 44: 0x0 - out (extention data 0)   60: 0x0 -
 * 45: 0x0 - out (extention data 1)   61: 0x0 -
 * 46: 0x0 - out (extention data 2)   62: 0x0 -
 * 47: 0x0 - out (extention addr 0)   63: 0x0 -
 *
 * Note that GPIO[44-47] can be out enabled to address EXT register.
 * At boot time, they are configured to get the board ID.
 *
 * bitmap: 0000 0000 0000 0000 0000 0001 1111 0101
 *
 */
#define COMMON_GPIO_OE_HIGH	0x000001F5

/*
 * GPIO data out register (high):
 *
 * Startup values ("/" means set when low)
 *
 * 32: 0x0 -                          48: 0x0 - off (extention addr 1)
 * 33: 0x0 - /off (fan speed bit 2)   49: 0x0 - off (extention addr 2)
 * 34: 0x0 -                          50: 0x0 -
 * 35: 0x1 - on (inhibit power off)   51: 0x0 -
 * 36: 0x0 -                          52: 0x0 -
 * 37: 0x0 -                          53: 0x0 -
 * 38: 0x0 -                          54: 0x0 -
 * 39: 0x0 -                          55: 0x0 -
 * 40: 0x0 -                          56: 0x0 -
 * 41: 0x1 - on  (power on hd3)       57: 0x0 -
 * 42: 0x1 - on  (power on hd4)       58: 0x0 -
 * 43: 0x1 - on  (power on hd5)       59: 0x0 -
 * 44: 0x0 - off  (extention data 0)  60: 0x0 -
 * 45: 0x0 - off  (extention data 1)  61: 0x0 -
 * 46: 0x0 - off  (extention data 2)  62: 0x0 -
 * 47: 0x0 - off  (extention addr 0)  63: 0x0 -
 *
 * bitmap: 0000 0000 0000 0000 0000 1110 0000 1000
 *
 */
#define COMMON_GPIO_OE_VAL_HIGH	0x00000E08

/* GPIO data in Polarity register (low) */
#define COMMON_GPIO_IN_POL_LOW	0L

/* GPIO data in Polarity register (high) */
#define COMMON_GPIO_IN_POL_HIGH	0L

/*
 * Common functions related with the Marvell board environment
 */
void gpio_out_keep_values(u32 boardId, u32 *gpio_out_keep_map);

#endif /* __ARCH_FEROCEON_KW_COMMON_BOARDENV_H */
