/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/netspace_lite_v2-boardenv.h
 *
 * LaCie Network Space Mini v2 board description.
 *
 * Copyright (C) 2010 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARCH_FEROCEON_KW_NETSPACE_LITE_V2_BOARDENV_H
#define __ARCH_FEROCEON_KW_NETSPACE_LITE_V2_BOARDENV_H

#include <linux/bitops.h>
#include "common-boardenv.h"

/*
 * The LaCie Network Space Mini v2 board is based on a Marvell Kirkwood
 * SoC 88F6192.
 */

/*
 * MPP configuration
 */

#define NETSPACE_LITE_V2_MPP0_7		COMMON_MPP0_7
#define NETSPACE_LITE_V2_MPP8_15	COMMON_MPP8_15
/*
 * MPP[16-23] definition:
 * 16: GPIO                     - 0x0
 * 17: GPIO                     - 0x0
 * 18: Nand Flash IO            - 0x1
 * 19: Nand Flash IO            - 0x1
 * 20: GPIO                     - 0x0
 * 21: LED SATA0 activity       - 0x5
 * 22: GPIO                     - 0x0
 * 23: GPIO                     - 0x0
 */
#define NETSPACE_LITE_V2_MPP16_23	0x00501100
#define NETSPACE_LITE_V2_MPP24_31	COMMON_MPP24_31
#define NETSPACE_LITE_V2_MPP32_35	0x00000000

/*
 * GPIO configuration
 */

/*
 * GPIO data out enable control register (low):
 * Bit low enable GPIO port output
 *
 * revision A:
 *
 * 0:  0x0 -                          16: 0x0 - out (power on hd1)
 * 1:  0x0 -                          17: 0x0 - out (power on hd2)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 -
 * 5:  0x0 -                          21: 0x0 -
 * 6:  0x0 -                          22: 0x0 - out (fan speed bit 0)
 * 7:  0x0 - out (fan speed bit 1)    23: 0x0 - out (fan power)
 * 8:  0x0 -                          24: 0x0 - out (USB device select)
 * 9:  0x0 -                          25: 0x1 - /in (fan fail)
 * 10: 0x0 -                          26: 0x1 - in  (USB device VBus)
 * 11: 0x0 -                          27: 0x0 -
 * 12: 0x0 - out (front red LED)      28: 0x0 - out (USB VBUS front)
 * 13: 0x1 - PHY interrupt            29: 0x0 -
 * 14: 0x1 - in  (USB fuse)           30: 0x0 - out (LED command)
 * 15: 0x0 -                          31: 0x0 - out (board power off)
 *
 * bitmap: 0000 0110 0000 0000 0110 0000 0000 0000
 *
 * revision B:
 *
 * 29: 0x0 - out (push button latch enable)
 *
 */
#define NETSPACE_LITE_V2_GPIO_OUT_LOW		0x06006000

/*
 * GPIO data out register (low):
 *
 * revision A:
 *
 * 0:  0x0 -                          16: 0x1 - on  (power on hd1)
 * 1:  0x0 -                          17: 0x1 - on  (power on hd2)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 -
 * 5:  0x0 -                          21: 0x0 -
 * 6:  0x0 -                          22: 0x0 - off (fan speed bit 0)
 * 7:  0x0 - off (fan speed bit 1)    23: 0x0 - off (fan power)
 * 8:  0x0 -                          24: 0x0 - off (USB device select)
 * 9:  0x0 -                          25: 0x0 -
 * 10: 0x0 -                          26: 0x0 -
 * 11: 0x0 -                          27: 0x0 -
 * 12: 0x0 - off (front red LED)      28: 0x0 - off (USB VBUS front)
 * 13: 0x0 -                          29: 0x0 -
 * 14: 0x0 -                          30: 0x0 - off (LED command)
 * 15: 0x0 -                          31: 0x0 - off (board power off)
 *
 * bitmap: 0000 0000 0010 0011 0000 0000 0000 0000
 *
 * revision B:
 *
 * 29: 0x1 - /off (push button latch enable)
 *
 * bitmap: 0010 0000 0010 0011 0000 0000 0000 0000
 *
 */
#define NETSPACE_LITE_V2_REVA_GPIO_VAL_LOW	0x00030000
#define NETSPACE_LITE_V2_REVB_GPIO_VAL_LOW	0x20030000

/*
 * GPIO data out enable control register (high):
 * Bit low enable GPIO port output
 *
 * 32: 0x1 - in  (push button)
 * 33: 0x0 - out (fan speed bit 2)
 * 34: 0x0 -
 * 35: 0x0 -
 *
 * bitmap: 0000 0000 0000 0000 0000 0000 0000 0001
 *
 */
#define NETSPACE_LITE_V2_GPIO_OUT_HIGH		0x00000001

/*
 * GPIO data out register (high):
 *
 * Startup values ("/" means set when low)
 *
 * 32: 0x0 -
 * 33: 0x0 - off (fan speed bit 2)
 * 34: 0x0 -
 * 35: 0x0 -
 *
 * bitmap: 0000 0000 0000 0000 0000 0000 0000 0000
 *
 */
#define NETSPACE_LITE_V2_GPIO_VAL_HIGH		0x00000000

#define NETSPACE_LITE_V2_GPIO_IN_POL_LOW	COMMON_GPIO_IN_POL_LOW
#define NETSPACE_LITE_V2_GPIO_IN_POL_HIGH	COMMON_GPIO_IN_POL_HIGH

/*
 * Export some GPIO pin number (especially those used for the
 * platform device registration)
 */

/* Buttons */
#define NETSPACE_LITE_V2_GPIO_KEY_POWER		32
/* Enable/disable latch mode for the power GPIO button. This latch mode is only
 * used by U-Boot. It allow to record a button push event when U-Boot is not
 * fully loaded. The latch mode must be _disabled_ under Linux. */
#define NETSPACE_LITE_V2_GPIO_KEY_POWER_LE      29

/* LEDs */
#define NETSPACE_LITE_V2_GPIO_LED_RED		12
#define NETSPACE_LITE_V2_GPIO_LED_BLUE		21
/*
 * After a board reset, the front blue LED light up (due to MPP{20,21} value
 * at reset). The command LED GPIO is used by the boot loader to set off this
 * initial LED state. From the Linux point, this GPIO is useless.
 */
#define NETSPACE_LITE_V2_GPIO_LED_BLUE_CMD	30

/* Ethernet */
#define NETSPACE_LITE_V2_GPIO_WOL		13

/* USB */
#define NETSPACE_LITE_V2_GPIO_USB_FUSE		14
#define NETSPACE_LITE_V2_GPIO_USB_MODE		24
#define NETSPACE_LITE_V2_GPIO_USB_VBUS_IN	26
#define NETSPACE_LITE_V2_GPIO_USB_VBUS_OUT	28

/* Fan */
#define NETSPACE_LITE_V2_GPIO_FAN_POWER		23
/*
 * speed[2:0] determine the voltage powering the fan
 */
#define NETSPACE_LITE_V2_GPIO_FAN_SPEED_0	22
#define NETSPACE_LITE_V2_GPIO_FAN_SPEED_1	7
#define NETSPACE_LITE_V2_GPIO_FAN_SPEED_2	33
#define NETSPACE_LITE_V2_GPIO_FAN_POWER		23
#define NETSPACE_LITE_V2_GPIO_FAN_FAIL		25

/* Hard disk power */
#define NETSPACE_LITE_V2_GPIO_HD0_POWER 	16

/* Board power off */
#define NETSPACE_LITE_V2_GPIO_POWER_OFF		31

/*
 * Keep some output GPIOs already configured by U-Boot: LEDs, fan and VBUS on
 * USB ports (needed when the boot device is an USB disk).
 */
#define NETSPACE_LITE_V2_GPIO_OUT_KEEP_LOW	\
	(					\
		BIT_MASK(7)  |			\
		BIT_MASK(22) |			\
		BIT_MASK(23) |			\
		BIT_MASK(28) |			\
		BIT_MASK(30)			\
	)

#define NETSPACE_LITE_V2_GPIO_OUT_KEEP_HIGH	BIT_MASK(1)

enum {
	NS2_LITE_REV_A, /* 0 */
	NS2_LITE_REV_B, /* 1 */
};

/*
 * Functions related with the Marvell board environment
 */
void netspace_lite_v2_boardenv_early_init(void);

#endif /* __ARCH_FEROCEON_KW_NETSPACE_LITE_V2_BOARDENV_H */
