/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/wireless_space-boardenv.c
 *
 * LaCie Network Space v2 board description.
 *
 * Copyright (c) 2009 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wireless_space-boardenv.h"
#include "mvCommon.h"
#include "twsi/mvTwsi.h"

MV_U8 wireless_space_BoardDebugLedIf[0];

/*
 * PHY device configuration
 */
MV_BOARD_MAC_INFO wireless_space_BoardMacInfo[] = {
	{ BOARD_MAC_SPEED_1000M, 0xa },
	{ BOARD_MAC_SPEED_100M, 0x6 },
};

/*
 * TWSI devices definition
 */
MV_BOARD_TWSI_INFO wireless_space_BoardTwsiDev[0];

/*
 * GPP connection definition
 *
 * Example with USB VBUS detection connected on GPP pin 1:
 * {{BOARD_DEV_USB_VBUS, 1}}
 */
MV_BOARD_GPP_INFO wireless_space_GppInfo[0];

/* Set the MPP type information to MV_BOARD_OTHER. No autodetection is
 * needed because the MPP configuration is fully supplied. */
MV_BOARD_MPP_TYPE_INFO wireless_space_BoardMppTypeInfo[] = {
	{ MV_BOARD_OTHER, MV_BOARD_OTHER },
};

/*
 * Device bus configuration
 */
MV_DEV_CS_INFO wireless_space_BoardDeCsInfo[] = {
	{ 0, N_A, BOARD_DEV_NAND_FLASH, 8 },
};

MV_BOARD_MPP_INFO wireless_space_BoardMppConfigValue[] = {
	{
		{
			WIRELESS_SPACE_MPP0_7,
			WIRELESS_SPACE_MPP8_15,
			WIRELESS_SPACE_MPP16_23,
			WIRELESS_SPACE_MPP24_31,
			WIRELESS_SPACE_MPP32_39,
			WIRELESS_SPACE_MPP40_47,
			WIRELESS_SPACE_MPP48_55,
		},
	},
};

MV_BOARD_SWITCH_INFO wireless_space_BoardSwitchInfo[] = {
	{
		.linkStatusIrq	= WIRELESS_SPACE_GPIO_ETHERNET_SWITCH,
		.qdPort		= { 0, 1, 2, -1, -1 },
		.qdCpuPort	= 5,
		.smiScanMode	= 2,
		.switchOnPort	= 0,
	}, {
		.switchOnPort	= -1,
	},
};


MV_BOARD_INFO wireless_space_Info = {
	/* Board name */
	"wireless_space",
	/* MPP group types */
	ARRAY_SIZE(wireless_space_BoardMppTypeInfo),
	wireless_space_BoardMppTypeInfo,
	/* Board MPP config */
	ARRAY_SIZE(wireless_space_BoardMppConfigValue),
	wireless_space_BoardMppConfigValue,
	/* Interrupts GPP mask low */
	0,
	/* Interrupts GPP mask high */
	0,
	/* Device bus configuration */
	ARRAY_SIZE(wireless_space_BoardDeCsInfo),
	wireless_space_BoardDeCsInfo,
	/* TWSI devices definition */
	ARRAY_SIZE(wireless_space_BoardTwsiDev),
	wireless_space_BoardTwsiDev,
	/* PHY devices configuration */
	ARRAY_SIZE(wireless_space_BoardMacInfo),
	wireless_space_BoardMacInfo,
	/* GPP connection definition */
	ARRAY_SIZE(wireless_space_GppInfo),
	wireless_space_GppInfo,
	/* LED configuration */
	0,
	NULL,
	0,
	/* GPIO data out enable control register */
	WIRELESS_SPACE_GPIO_OE_LOW,
	WIRELESS_SPACE_GPIO_OE_HIGH,
	/* GPIO data out register */
	WIRELESS_SPACE_GPIO_OE_VAL_LOW,
	WIRELESS_SPACE_GPIO_OE_VAL_HIGH,
	/* GPIO data in Polarity register */
	WIRELESS_SPACE_GPIO_IN_POL_LOW,
	WIRELESS_SPACE_GPIO_IN_POL_HIGH,
	/* Switch info */
	wireless_space_BoardSwitchInfo,
	/* Initial values for NAND flash registers */
	WIRELESS_SPACE_NAND_READ_PARAM_REG,
	WIRELESS_SPACE_NAND_WRITE_PARAM_REG,
	WIRELESS_SPACE_NAND_CTRL_REG,
};

u32 __initdata wireless_space_gpio_out_keep_map[2] = {
	WIRELESS_SPACE_GPIO_OUT_KEEP_LOW,
	WIRELESS_SPACE_GPIO_OUT_KEEP_HIGH,
};

void __init wireless_space_boardenv_early_init(void)
{
	u32 boardId = mvBoardIdGet();

	gpio_out_keep_values(boardId, wireless_space_gpio_out_keep_map);
}
