/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/wireless_space-boardenv.h
 *
 * LaCie Network Space v2 board description.
 *
 * Copyright (c) 2009 LaCie
 *	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARCH_FEROCEON_KW_WIRELESS_SPACE_BOARDENV_H
#define __ARCH_FEROCEON_KW_WIRELESS_SPACE_BOARDENV_H

#include <linux/bitops.h>
#include "common-boardenv.h"

/*
 * The LaCie Wireless Space board is based on a Marvell Kirkwood SoC 88F6281.
 */

/*
 * NAND configuration
 */
#define WIRELESS_SPACE_NAND_READ_PARAM_REG	0x003E07CF
#define WIRELESS_SPACE_NAND_WRITE_PARAM_REG	0x000F0F0F
#define WIRELESS_SPACE_NAND_CTRL_REG		0x01C7D943

/*
 * MPP configuration
 */

/*
 * MPP[0-7] definition:
 * 0: Nand Flash IO             - 0x1
 * 1: Nand Flash IO             - 0x1
 * 2: Nand Flash IO             - 0x1
 * 3: Nand Flash IO             - 0x1
 * 4: Nand Flash IO             - 0x1
 * 5: Nand Flash IO             - 0x1
 * 6: System Reset              - 0x1
 * 7: GPIO                      - 0x0
 */
#define WIRELESS_SPACE_MPP0_7	0x01111111

/*
 * MPP[8-15] definition:
 * 8:  tw data (i2c)            - 0x1
 * 9:  tw clock (i2c)           - 0x1
 * 10: UART0-TX                 - 0x3
 * 11: UART0-RX                 - 0x3
 * 12: GPIO                     - 0x0
 * 13: GPIO                     - 0x0
 * 14: GPIO                     - 0x0
 * 15: SATA0 activity           - 0x4
 */
#define WIRELESS_SPACE_MPP8_15	0x40003311

/*
 * MPP[16-23] definition:
 * 16: GPIO (SATA0 power)       - 0x0
 * 17: GPIO                     - 0x0
 * 18: Nand Flash IO            - 0x1
 * 19: Nand Flash IO            - 0x1
 * 20: Gigabit Ethernet         - 0x3
 * 21: Gigabit Ethernet         - 0x3
 * 22: Gigabit Ethernet         - 0x3
 * 23: Gigabit Ethernet         - 0x3
 */
#define WIRELESS_SPACE_MPP16_23	0x33331100

/*
 * MPP[24-31] definition:
 * 24: Gigabit Ethernet         - 0x3
 * 25: Gigabit Ethernet         - 0x3
 * 26: Gigabit Ethernet         - 0x3
 * 27: Gigabit Ethernet         - 0x3
 * 28: Gigabit Ethernet         - 0x3
 * 29: Gigabit Ethernet         - 0x3
 * 30: Gigabit Ethernet         - 0x3
 * 31: Gigabit Ethernet         - 0x3
 */
#define WIRELESS_SPACE_MPP24_31	0x33333333

/*
 * MPP[32-39] definition:
 * 32: Gigabit Ethernet         - 0x3
 * 33: Gigabit Ethernet         - 0x3
 * 34: Gigabit Ethernet         - 0x3
 * 35: Gigabit Ethernet         - 0x3
 * 36: GPIO                     - 0x0
 * 37: GPIO                     - 0x0
 * 38: GPIO                     - 0x0
 * 39: GPIO                     - 0x0
 */
#define WIRELESS_SPACE_MPP32_39	0x00003333

#define WIRELESS_SPACE_MPP40_47	COMMON_MPP40_47
#define WIRELESS_SPACE_MPP48_55	COMMON_MPP48_55

/*
 * GPIO configuration
 */

/*
 * Startup values ("/" means set when low)
 * Bit low enable GPIO port output
 *
 * GPIO data out enable control register (low):
 * 0:  0x0 -                          16: 0x0 - out (power on hd1)
 * 1:  0x0 -                          17: 0x0 - out (board power off)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 -
 * 5:  0x0 -                          21: 0x0 -
 * 6:  0x0 -                          22: 0x0 -
 * 7:  0x0 - out (fan speed bit 1)    23: 0x0 -
 * 8:  0x0 -                          24: 0x0 -
 * 9:  0x0 -                          25: 0x0 -
 * 10: 0x0 -                          26: 0x0 -
 * 11: 0x0 -                          27: 0x0 -
 * 12: 0x0 -                          28: 0x0 -
 * 13: 0x1 - in  (rear power button)  29: 0x0 -
 * 14: 0x1 - in  (USB fuse)           30: 0x0 -
 * 15: 0x0 -                          31: 0x0 -
 *
 * bitmap: 0000 0000 0000 0000 0110 0000 0000 0000
 *
 */
#define WIRELESS_SPACE_GPIO_OE_LOW		0x00006000

/*
 * GPIO data out enable control register (high):
 * Bit low enable GPIO port output
 *
 * 32: 0x0 -                          48: 0x0 - out (LED blue enable)
 * 33: 0x0 -                          49: 0x0 -
 * 34: 0x0 -                          50: 0x0 -
 * 35: 0x0 -                          51: 0x0 -
 * 36: 0x0 - out (fan speed bit 2)    52: 0x0 -
 * 37: 0x0 - out (fan speed bit 0)    53: 0x0 -
 * 38: 0x0 - out (fan power)          54: 0x0 -
 * 39: 0x1 - in  (fan fail)           55: 0x0 -
 * 40: 0x1 - in  (ETH switch signal)  56: 0x0 -
 * 41: 0x0 - out (USB VBUS enable)    57: 0x0 -
 * 42: 0x0 - out (EXT-ALE)            58: 0x0 -
 * 43: 0x1 - in  (front Wi-Fi button) 59: 0x0 -
 * 44: 0x0 - out (LED red enable)     60: 0x0 -
 * 45: 0x0 - out (LED red blink)      61: 0x0 -
 * 46: 0x0 - out (LED green enable)   62: 0x0 -
 * 47: 0x0 - out (LED SATA activity   63: 0x0 -
 *                blink)
 *
 * Note that GPIO[44-47] can be out enabled to address EXT register.
 * At boot time, they are configured to get the board ID.
 *
 * bitmap: 0000 0000 0000 0000 0000 1001 1000 0000
 *
 */
#define WIRELESS_SPACE_GPIO_OE_HIGH		0x00000980

/*
 * GPIO data out register (low):
 *
 * Startup values ("/" means set when low)
 *
 * 0:  0x0 -                          16: 0x1 - on  (power on hd1)
 * 1:  0x0 -                          17: 0x0 - off (board power off)
 * 2:  0x0 -                          18: 0x0 -
 * 3:  0x0 -                          19: 0x0 -
 * 4:  0x0 -                          20: 0x0 -
 * 5:  0x0 -                          21: 0x0 -
 * 6:  0x0 -                          22: 0x0 -
 * 7:  0x0 - out (fan speed bit 1)    23: 0x0 -
 * 8:  0x0 -                          24: 0x0 -
 * 9:  0x0 -                          25: 0x0 -
 * 10: 0x0 -                          26: 0x0 -
 * 11: 0x0 -                          27: 0x0 -
 * 12: 0x0 -                          28: 0x0 -
 * 13: 0x0 -                          29: 0x0 -
 * 14: 0x0 -                          30: 0x0 -
 * 15: 0x0 -                          31: 0x0 -
 *
 * bitmap: 0000 0000 0000 0001 0000 0000 0000 0000
 *
 */
#define WIRELESS_SPACE_GPIO_OE_VAL_LOW		0x00010000

/*
 * GPIO data out register (high):
 *
 * Startup values ("/" means set when low)
 *
 * 32: 0x0 -                          48: 0x0 - off (LED blue enable)
 * 33: 0x0 -                          49: 0x0 -
 * 34: 0x0 -                          50: 0x0 -
 * 35: 0x0 -                          51: 0x0 -
 * 36: 0x0 - off (fan speed bit 2)    52: 0x0 -
 * 37: 0x0 - off (fan speed bit 0)    53: 0x0 -
 * 38: 0x0 - off (fan power)          54: 0x0 -
 * 39: 0x0 -                          55: 0x0 -
 * 40: 0x0 -                          56: 0x0 -
 * 41: 0x1 - on  (USB VBUS enable)    57: 0x0 -
 * 42: 0x0 - off (EXT-ALE)            58: 0x0 -
 * 43: 0x0 -                          59: 0x0 -
 * 44: 0x0 - off (LED red enable)     60: 0x0 -
 * 45: 0x1 - /off (LED red blink)     61: 0x0 -
 * 46: 0x0 - off (LED green enable)   62: 0x0 -
 * 47: 0x1 - /off (LED SATA activity  63: 0x0 -
 *                 blink)
 *
 * bitmap: 0000 0000 0000 0000 1010 0010 0000 0000
 *
 */
#define WIRELESS_SPACE_GPIO_OE_VAL_HIGH		0x0000A200

#define WIRELESS_SPACE_GPIO_IN_POL_LOW		COMMON_GPIO_IN_POL_LOW
#define WIRELESS_SPACE_GPIO_IN_POL_HIGH		COMMON_GPIO_IN_POL_HIGH | BIT_MASK(8)

/*
 * Export some GPIO pin number (especially those used for the
 * platform device registration)
 */

/* Buttons */
#define WIRELESS_SPACE_GPIO_KEY_POWER		13
#define WIRELESS_SPACE_GPIO_KEY_WPS		43

/* Ethernet switch */
#define WIRELESS_SPACE_GPIO_ETHERNET_SWITCH	40

/* LEDs */
#define WIRELESS_SPACE_GPIO_LED_CLK_CTRL	42
#define WIRELESS_SPACE_GPIO_LED_RED		44
#define WIRELESS_SPACE_GPIO_LED_RED_BLINK	45
#define WIRELESS_SPACE_GPIO_LED_GREEN		46
#define WIRELESS_SPACE_GPIO_LED_SATA_BLINK	47
#define WIRELESS_SPACE_GPIO_LED_BLUE		48

/* GPIO fan */
#define WIRELESS_SPACE_GPIO_FAN_POWER		38
#define WIRELESS_SPACE_GPIO_FAN_SPEED_0		37
#define WIRELESS_SPACE_GPIO_FAN_SPEED_1		7
#define WIRELESS_SPACE_GPIO_FAN_SPEED_2		36
#define WIRELESS_SPACE_GPIO_FAN_FAIL		39

/* GPIO USB */
#define WIRELESS_SPACE_GPIO_USB_FUSE		14
#define WIRELESS_SPACE_GPIO_USB_VBUS_OUT	41

/* harddisk power */
#define WIRELESS_SPACE_GPIO_HD0_POWER		16

/* Board power off */
#define WIRELESS_SPACE_GPIO_POWER_OFF		17

/*
 * Keep some output GPIOs already configured by U-Boot: LEDs and fan
 */
#define WIRELESS_SPACE_GPIO_OUT_KEEP_LOW	BIT_MASK(7)
#define WIRELESS_SPACE_GPIO_OUT_KEEP_HIGH	\
	(					\
		BIT_MASK(4)  |			\
		BIT_MASK(5)  |			\
		BIT_MASK(6)  |			\
		BIT_MASK(10) |			\
		BIT_MASK(12) |			\
		BIT_MASK(13) |			\
		BIT_MASK(14) |			\
		BIT_MASK(15) |			\
		BIT_MASK(16)			\
	)

/*
 * Functions related with the Marvell board environment
 */
void wireless_space_boardenv_early_init(void);

#endif /* __ARCH_FEROCEON_KW_WIRELESS_SPACE_BOARDENV_H */
