/*
 * arch/arm/mach-feroceon-kw/mpp.c
 *
 * Some MPP functions for Marvell Orion Kirkwood SoCs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/io.h>
#include <asm/gpio.h>
#include "mpp.h"

#ifdef CONFIG_DEBUG_FS

#include <linux/debugfs.h>
#include <linux/seq_file.h>

static int dbg_mpp_show(struct seq_file *s, void *unused)
{
	seq_printf(s, "MPP control 0 register: 0x%08x\n",
		   readl(MPP_0_7_CTRL));
	seq_printf(s, "MPP control 1 register: 0x%08x\n",
		   readl(MPP_8_15_CTRL));
	seq_printf(s, "MPP control 2 register: 0x%08x\n",
		   readl(MPP_16_23_CTRL));
	seq_printf(s, "MPP control 3 register: 0x%08x\n",
		   readl(MPP_24_31_CTRL));
	seq_printf(s, "MPP control 4 register: 0x%08x\n",
		   readl(MPP_32_39_CTRL));
	seq_printf(s, "MPP control 5 register: 0x%08x\n",
		   readl(MPP_40_47_CTRL));
	seq_printf(s, "MPP control 6 register: 0x%08x\n",
		   readl(MPP_48_49_CTRL));
	return 0;
}

static int dbg_mpp_open(struct inode *inode, struct file *file)
{
	return single_open(file, dbg_mpp_show, &inode->i_private);
}

static struct file_operations feroceon_kw_mpp_debug_operations={
	.open		= dbg_mpp_open,
	.read 		= seq_read,
	.llseek 	= seq_lseek,
	.release	= single_release,
};

static int __init feroceon_kw_mpp_debug(void)
{
	debugfs_create_file("mpp", S_IRUGO, NULL, NULL,
			    &feroceon_kw_mpp_debug_operations);
	return 0;
}
late_initcall(feroceon_kw_mpp_debug);
#endif

void __init feroceon_kw_mpp_conf(void)
{
	int mpp;
	u32 mpp_reg_ctrl[7];

	/* Initialize gpiolib. */
	feroceon_gpio_init();

	mpp_reg_ctrl[0] = readl(MPP_0_7_CTRL);
	mpp_reg_ctrl[1] = readl(MPP_8_15_CTRL);
	mpp_reg_ctrl[2] = readl(MPP_16_23_CTRL);
	mpp_reg_ctrl[3] = readl(MPP_24_31_CTRL);
	mpp_reg_ctrl[4] = readl(MPP_32_39_CTRL);
	mpp_reg_ctrl[5] = readl(MPP_40_47_CTRL);
	mpp_reg_ctrl[6] = readl(MPP_48_49_CTRL);

	for (mpp = 0; mpp < MPP_NUM; mpp++) {
		int group = mpp / 8;
		int shift = mpp % 8;
		u32 reg = mpp_reg_ctrl[group];
		int mpp_val;

		mpp_val = (reg >> 4 * shift) & 0xf;

		/* If the mpp if configured to act like a gpio, mark
		 * the gpio pin as active. */
		if (mpp_val == 0)
			feroceon_gpio_set_valid(mpp, 1);
	}
}
