/*
 * lacie/drivers/gpio-hd-power.h
 *
 * LaCie harddisk power driver
 *
 * Copyright (c) 2009 LaCie
 * 	Benoît Canet <benoit.canet@gmail.com>
 * 	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LACIE_GPIO_HD_POWER_H
#define __LACIE_GPIO_HD_POWER_H

struct gpio_hd_power {
	const char	*name;
	unsigned	power_pin;
	unsigned	pres_pin;
	u8		have_power_pin:1;
	u8		have_pres_pin:1;
	u8		power_act_low:1;
	u8		pres_act_low:1;
	u8		is_extern:1;
};

struct gpio_hd_power_platform_data {
	int 			num_hds;
	struct gpio_hd_power 	*hd;
};

#define MAX_DISK_NUM	8

#endif /* __LACIE_GPIO_HD_POWER_H */
