/*
 * lacie/drivers/gpio-usb.h
 *
 * LaCie GPIO USB driver.
 *
 * Copyright (C) 2009 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LACIE_GPIO_USB_H
#define __LACIE_GPIO_USB_H

enum gpio_usb_types {
	GPIO_USB_FUSE,
	GPIO_USB_MODE,
	GPIO_USB_VBUS_IN,
	GPIO_USB_VBUS_OUT,
	GPIO_USB_TYPES_NUM,
};

struct gpio_usb {
	const char *name;
	unsigned num;
	unsigned act_low;
	enum gpio_usb_types type;
};

/*
 * Container for a a set of GPIOs associated with an USB port.
 */
struct gpio_usb_port {
	const char *name;
	int num_gpio;
	struct gpio_usb *gpio;
	unsigned long reload_delay; /* fuse reload delay in msecs. */
	unsigned long spurious_delay; /* fuse spurious irq delay in msecs. */
};

struct gpio_usb_platform_data {
	int num_port;
	struct gpio_usb_port *port;
};

#endif /* __LACIE_GPIO_USB_H */
