/*
 * lacie/drivers/gpio-ws-leds.h
 *
 * LaCie GPIO extension LEDs driver.
 *
 * Copyright (c) 2009 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GPIO_WS_LEDS_H
#define __GPIO_WS_LEDS_H

struct ws_led_gpio {
	const char		*name;
	unsigned		gpio;
	u8			active_low;
};

struct ws_led {
	const char		*name;
	const char		*default_trigger;
	struct ws_led_gpio	enable;
	struct ws_led_gpio	hw_blink;
	u32			delay_on;
	u32			delay_off;
	u8			have_hd_blink:1;
	u8			have_hw_blink:1;
};

struct ws_led_platform_data {
	int			num_leds;
	struct ws_led		*leds;
	/* Clock control and SATA blink GPIOs are shared
	 * between all the LEDs. */
	struct ws_led_gpio	clk_ctrl;
	struct ws_led_gpio	hd_blink;
};

#endif /* __GPIO_WS_LEDS_H */
