#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

#define FILENAME	"text.log"


void Example_Main(void)
{
	LOG_DEBUG("some interesting line");
	{
		TRandom *Rand;
		char Line[512];
		int i;
		
		Rand = Random_Create(72073);
		
		for(i=0;i<128;i++)
		{
			Random_String(Rand, 64, 256, Line);
			LOG_DEBUG("%s", Line);
		}
		
		Random_Destroy(Rand);
	}
	
	LOG_ERROR("this is an error line");
	LOG_INFO("this is an info line");
	LOG_DEBUG("this is an debug line");
	
	{
		TLog *Log;
		Log = Log_GetDefault();
		Log->Mode |= LOG_NO_COLOR;
	}
	
	LOG_ERROR("this is an error line");
	LOG_INFO("this is an info line");
	LOG_DEBUG("this is an debug line");
}


void Example_Rotate(void)
{
	FILE *File;
	
	File = fopen(FILENAME, "w");
	{
		TLog Log;
		
		Log_Reset(&Log);
		Log_SetMode(&Log, LOG_AUTO_FLUSH | LOG_THREAD_SAFE | LOG_SHOW_DATE | LOG_SHOW_FILE | LOG_SHOW_LINE | LOG_SHOW_FUNCTION | LOG_SHOW_THREADID | LOG_SHOW_PID);
		Log_SetFile(&Log, File);
		Log_SetPadding(&Log, 100);
		Log.szOutMax = 2048;
		Log.nRotateFile = 5;
		Log.Filename = FILENAME;
		Log_SetDefault(&Log);
	}
	
	Example_Main();
	
	fclose(File);
}


void LogCallback(char *Line, void *Data)
{
	char *Prefix = (char*)Data;
	printf("%s %s", Prefix, Line);
}


void Example_Callback(void)
{
	char *Prefix = ">>>";
	
	{
		TLog Log;
		
		Log_Reset(&Log);
		Log_SetMode(&Log, LOG_AUTO_FLUSH | LOG_THREAD_SAFE | LOG_SHOW_DATE | LOG_SHOW_FILE | LOG_SHOW_LINE | LOG_SHOW_FUNCTION | LOG_SHOW_THREADID | LOG_SHOW_PID);
		Log_SetCallback(&Log, LogCallback, Prefix);
		Log_SetDefault(&Log);
	}
	
	Example_Main();
}


void Example_Default(void)
{
	Example_Main();
}


void Example_Speed(void)
{
	uint32 TickStart;
	int i, TickElapsed;
	
	{
		TLog Log;
		
		Log_Reset(&Log);
		Log_SetMode(&Log, LOG_AUTO_FLUSH | LOG_THREAD_SAFE | LOG_SHOW_DATE | LOG_SHOW_FILE | LOG_SHOW_LINE | LOG_SHOW_FUNCTION | LOG_SHOW_THREADID | LOG_SHOW_PID);
		Log_SetPadding(&Log, 100);
		Log_SetDefault(&Log);
	}
	
	TickStart = Time_GetTick();
	for(i=0;i<10000;i++)
	{
		LOG_DEBUG("#%d#", i);
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
		LOG_DEBUG("<------------------------>");
	}
	TickElapsed = Time_GetElapsedTick(TickStart);
	LOG_DEBUG("time spent: %d ms.", TickElapsed);
}


int main(int nArgs, char **Args)
{
	char *Mode;
	
	if(nArgs != 2)
	{
		printf("Usage: %s default|rotate|callback|speed\n", Args[0]);
		return 1;
	}
	
	Mode = Args[1];
	
	if(String_Equal(Mode, "rotate"))
		Example_Rotate();
	else if(String_Equal(Mode, "callback"))
		Example_Callback();
	else if(String_Equal(Mode, "speed"))
		Example_Speed();
	else
		Example_Default();
	
	return 0;
}
