#ifndef ___INC_CLI_PARSER_H___
#define ___INC_CLI_PARSER_H___

#define ARG_TYPE_NONE		0
#define ARG_TYPE_STRING		1	/* has argument of type string */
#define ARG_TYPE_INT		2	/* has argument of type int */
#define ARG_TYPE_FLAG		3	/* has no argument, but set MemArg to 1 if present, 0 if not */


typedef struct
{
	char *Command;
	int (*Function)(char **Args, int nArgs);
	
}TCliParserCommand;


typedef struct
{
	char *	ShortTag;			/* -a */
	char *	LongTag;			/* --argument */
	char *	Description;		/* short description */
	char *	TypicalValue;		/* file.dat | number | 17 */
	void *	pMem;				/* pointer to memory receiver */
	int		Type;
	int		Required;
	
	int Set;				/* for internal usage */
	
}TCliParserOption;


int CliParser_DoCommands(TCliParserCommand *Commands, char **Args, int lArgs, char *ProgName);
int CliParser_DoOptions(TCliParserOption *Options, char **Args, int lArgs);

/*
// use in called functions:
//	0 failed
//	1 success
int		Parser_GrabArgs(TParser_Arg *ArgParser, int nArgs, char **Args);

// use in main function
//	0 failed
//	1 success
int		Parser_Exec(int nArgs, char **Args, TParser_Command *Commands);

// use to display usage in a no-command program
void	Parser_NoCommandUsage(char *ProgName, TParser_Arg *ArgParser);


#define PARSER_MODE_NONE		0
#define PARSER_MODE_NODISPLAY	1

void	Parser_SetMode(int Flags);

char *	Parser_GetArg0(void);
*/

#endif
