#ifndef ___INC_DICTIONARY_H___
#define ___INC_DICTIONARY_H___

typedef SHRED_HANDLE TDictionary;

TDictionary *	Dictionary_CreateEx(int Modulus);
#define			Dictionary_Create() Dictionary_CreateEx(0)
void			Dictionary_Destroy(TDictionary *Handle);

void			Dictionary_Set(TDictionary *Handle, char *Key, char *Value);
void			Dictionary_Set_Int32(TDictionary *Handle, char *Key, int iValue);
void			Dictionary_Set_Dict(TDictionary *Handle1, char *Key, TDictionary *Handle2);

char *			Dictionary_GetValueByRef(TDictionary *Handle, char *Key);
char *			Dictionary_GetValue(TDictionary *Handle, char *Key, char *TmpBuf, int szTmpBuf);		// returns a pointer to the given string, or allocate memory if TmpBuf is NULL
#define			Dictionary_Get(h, k) Dictionary_GetValue((h), (k), NULL, 0)
int				Dictionary_Get_Int32(TDictionary *Handle, char *Key);
TDictionary *	Dictionary_Get_Dict(TDictionary *Handle, char *Key);

void			Dictionary_Delete(TDictionary *Handle, char *Key);
TDictionary *	Dictionary_Duplicate(TDictionary *Handle);
void			Dictionary_Merge(TDictionary *From, TDictionary *To);	// write From to To, overwrite values with same key

// Dictionary_GetKeys():
//	keys are sorted using natural string comparison
//	use StringArray_Free() to destroy results
#define			Dictionary_GetKeys(h, pk, plk)	Dictionary_GetKeysEx(h, pk, plk, 1)
void			Dictionary_GetKeysEx(TDictionary *Handle, char ***pKeys, int *plKeys, int Sort);

// Dictionary_Count(..., "Path.To") counts number of iterable entries of the form Path.To.$Numer.Name[...]
// Dictionary_Count(..., NULL) returns the number of items of the dictionary
int				Dictionary_Count(TDictionary *Handle, char *KeyPrefix);

int				Dictionary_Equal(TDictionary *Dict0, TDictionary *Dict1);

void			Dictionary_Dump(TDictionary *Handle);

int				Dictionary_WriteToFile(TDictionary *Handle, char *Filename);
TDictionary *	Dictionary_ReadFromFile(char *Filename);

char *			Dictionary_GetHash(TDictionary *Handle, char *TmpBuf, int szTmpBuf);

#endif
