#ifndef ___INC_IP_HELPERS_H___
#define ___INC_IP_HELPERS_H___

#define MAC_ADDR_RAW_SIZE	6
#define MAC_ADDR_STR_SIZE	(MAC_ADDR_RAW_SIZE * 3)
#define IP_ADDR_RAW_SIZE	4
#define IP_ADDR_STR_SIZE	(IP_ADDR_RAW_SIZE * 4)


typedef struct
{
	char *	Name;
	char *	Description;		// not available on linux
	uint32	dwIP;
	uint32	dwNetmask;
	uint8	bMAC[MAC_ADDR_RAW_SIZE];
	
}TInterfaceInfo;

typedef struct
{
	uint32	dwDestination;
	uint32	dwGateway;
	uint32	dwNetmask;
	
}TRouteInfo;

typedef struct
{
	uint32	dwIP;
	uint8	bMAC[MAC_ADDR_RAW_SIZE];
	
}TARPInfo;


// warning: all data are expressed in host order

// IP functions
int		IP_GetInterfaceTable(TInterfaceInfo **pIPInfo, int *pszIPInfo);
void	IP_FreeInterfaceTable(TInterfaceInfo *IPInfo, int szIPInfo);
TInterfaceInfo *IP_GetInterface(TInterfaceInfo *IPInfo, int szIPInfo, char *Name);

int		IP_GetRouteTable(TRouteInfo **pRouteInfo, int *pszRouteInfo);
int		IP_GetARPTable(TARPInfo **pARPInfo, int *pszARPInfo);

// high level functions
int		IP_GetDefaultInterfaceParams(char *Name, int szName, uint32 *pdwIP, uint32 *pdwNetmask, uint8 bMAC[MAC_ADDR_RAW_SIZE]);
uint32	IP_GetDefaultIPAddress(void);
uint32	IP_GetDefaultGateway(void);


// DNS functions
int		IP_GetDnsHostname(char *Hostname, int szHostname);
int		IP_GetDnsDomain(char *Domain, int szDomain);
int		IP_GetDnsServers(uint32	**pdwServers, int *pszServers);

int		IP_GetHostIP(char *Hostname, uint32 *pdwIP);
int		IP_GetHostIPEx(char *Hostname, uint32 **pdwIPList, int *plIPList);


// format convertion and IP calculus functions
char *	IP_MACToString(uint8 MAC[MAC_ADDR_RAW_SIZE], char *TmpBuf, int szTmpBuf);
int		IP_MACFromString(char *MAC, uint8 bMAC[MAC_ADDR_RAW_SIZE]);

uint32	IP_IPToUint32(char *IPString);
char *	IP_Uint32ToIP(uint32 dwIP, char *TmpBuf, int szTmpBuf);

//int		IP_NetmaskToCidr(char *Netmask);
int		IP_NetmaskToCidr(uint32 dwNetmask);
char *	IP_CidrToNetmask(int Cidr, char *TmpBuf, int szTmpBuf);

uint32	IP_GetNetworkAddr(uint32 dwIP, uint32 dwNetmask);
uint32	IP_GetBroadcastAddr(uint32 dwIP, uint32 dwNetmask);

uint32	IP_GetFirstAddr(uint32 dwIP, uint32 dwNetmask);
uint32	IP_GetLastAddr(uint32 dwIP, uint32 dwNetmask);

#endif
