#ifndef ___INC_MACROS_H___
#define ___INC_MACROS_H___

// optimized, safer
#ifndef WIN32_MSVC
#define USE_SAFE_MACRO
#endif

#ifndef MAX
	#ifndef USE_SAFE_MACRO
		#define MAX(u,v)	((u)>(v)?(u):(v))
	#else
		#define MAX(u,v) \
		({ \
			typeof(u) _u = (u); \
			typeof(v) _v = (v); \
			_u > _v ? _u : _v; \
		})
	#endif
#endif

#ifndef MIN
	#ifndef USE_SAFE_MACRO
		#define MIN(u,v)	((u)<(v)?(u):(v))
	#else
		#define MIN(u,v) \
		({ \
			typeof(u) _u = (u); \
			typeof(v) _v = (v); \
			_u < _v ? _u : _v; \
		})
	#endif
#endif

#ifndef ABS
	#ifndef USE_SAFE_MACRO
		#define ABS(u)		((u)<0?(-(u)):(u))
	#else
		#define ABS(u) \
		({ \
			typeof(u) _u = (u); \
			_u < 0 ? -u : u; \
		})
	#endif
#endif

#endif
