#ifndef ___INC_SYSTEM_H___
#define ___INC_SYSTEM_H___

void	System_SetDebug(int Debug);

#define System_SuccessToExitCode(s)	(!(s))

int		System_ExecuteGrabOutput(char *Cmd, char ***pLines, int *plLines);
int		System_ExecuteGrabOutput_FirstLine(char *Cmd, char *Line, int szLine);
int		System_Execute(char *Cmd);
#ifndef WIN32_MSVC
int		System_ExecuteArgs(char *Format, ...) __attribute__ ((format(printf, 1, 2)));
#else
int		System_ExecuteArgs(char *Format, ...);
#endif

uint32	System_GetLastErrorID(void);
char *	System_GetLastErrorString(uint32 ErrorID, char *TmpBuf, int szTmpBuf);

#ifndef WIN32
int		System_Daemonize(void);
int		System_DupOutputToFile(char *Filename, int DupStdOut, int DupStdErr);	// works ony after calling System_Daemonize()
int		System_IsRoot(void);
#else
int		System_WIN32_GetFileInfo(char *Filename, char *Name, char *Value, int szValue);
#endif

char *	System_GetCurrentUser(void);


typedef struct
{
	char *Name;
	char *Value;
	
}TEnvVar;

void	System_GetEnvironmentVars(TEnvVar **pEnvVars, int *pszEnvVars);
void	System_DestroyEnvironmentVars(TEnvVar *EnvVars, int szEnvVars);


typedef struct
{
	char *	Name;
	int		PID;
	int		ParentPID;
	int		nThreads;
	char *	State;
	int		IsKernelModule;
	
	struct
	{
		char **	Args;
		int		lArgs;
		
	} CmdLine;
	
}TProcessInfo;

int		System_GetProcessList(TProcessInfo **pProcessList, int *pszProcessList);
void	System_DestroyProcessList(TProcessInfo *ProcessList, int szProcessList);
int		System_GetPID(void);


int		System_IsBigEndian(void);
int		System_IsLittleEndian(void);
void	System_AssertEndianness(void);	// as it is an assertion, call exit on failure


typedef struct
{
	char	Name[64];
	char	VendorID[64];
	int		NumberOfProcessors;
	int		FrequencyMHz;
	int		Family;
	int		Model;
	int		Stepping;
	
}TProcessorInfo;


#ifndef WIN32_MSVC
#define System_GetCompilerVersion()			(__VERSION__)
#define System_GetCompilerVersionMajor()	(__GNUC__)
#define System_GetCompilerVersionMinor()	(__GNUC_MINOR__)
#define System_GetCompilerVersionPatch()	(__GNUC_PATCHLEVEL__)
#else
#define System_GetCompilerVersion()			"msvc"
#define System_GetCompilerVersionMajor()	(_MSC_VER / 100)
#define System_GetCompilerVersionMinor()	(_MSC_VER % 100)
#define System_GetCompilerVersionPatch()	0
#endif

char *	System_GetBuildDateEx(char *Date);
#define System_GetBuildDate()				System_GetBuildDateEx(__DATE__)
#define System_GetBuildTime()				(__TIME__)

char *	System_GetRuntimeVersion(void);

int		System_GetProcessorInfo(TProcessorInfo *Info);
int		System_GetProcessorFrequency(void);	// returns CPU frequency in MHz, 0 if not available

int		System_GetTotalPhysicalMemory(void);
int		System_GetFreePhysicalMemory(void);

char *	System_GetSystemVersion(void);
char *	System_GetSystemArch(void);
char *	System_GetKernelVersion(void);
#define System_GetMemoryAddressBits()		((int)(8 * sizeof(void*)))

int		System_GetUptime(uint32 *pUpTime);

void	System_Dump(void);

#endif
