#ifndef ___INC_THREADS_H___
#define ___INC_THREADS_H___

/*
	synchronisation
*/
void *	CriticalSection_Open(void);
void	CriticalSection_Close(void *Handle);
void	CriticalSection_Enter(void *Handle);
void	CriticalSection_Leave(void *Handle);


/*
	Functions to use for master/slave threads
*/

typedef int (*SlaveThreadProc)(void *Handle, void *Data);

int		Thread_Slave_GetCloseEvent(void *Handle);
int		Thread_Slave_GetCloseEventEx(void *Handle, int Timeout);
void	Thread_Slave_SelfDestruct(void *Handle);	// with this function, no need to call wait/close functions (fixme: check handle leak...)

void *	Thread_Master_Open(SlaveThreadProc Proc, void *Data);
void	Thread_Master_SetCloseEvent(void *Handle);
int		Thread_Master_WaitThreadTermination(void *Handle, int Timeout, int Block);
int		Thread_Master_Close(void *Handle);

int		Thread_Master_IsAlive(void *Handle);

/*
	Other functions
*/
#ifdef APPLE
typedef void * TThreadID;	// Apple does not follow real pthread convention for thread id, instead they use a pointer to struct _opaque_pthread_t
#else
typedef uint32 TThreadID;
#endif
TThreadID Thread_GetCurrentThreadId(void);


/*
	Interthread events
*/

void *	Thread_Event_Create(void);
void	Thread_Event_Destroy(void *Handle);
void	Thread_Event_Raise(void *Handle);

// timeout	< 0 => infinite
//			= 0 => return now
//			> 0 => wait until timeout
int		Thread_Event_Wait(void *Handle, int Timeout);


/*
	Interthread mutexes
*/

void *	Thread_Mutex_Open(void);
void	Thread_Mutex_Close(void *Handle);

// timeout	< 0 => infinite
//			= 0 => return now
//			> 0 => wait until timeout
int		Thread_Mutex_Wait(void *Handle, int Timeout);
void	Thread_Mutex_Release(void *Handle);

#endif
