#ifndef ___INC_TIME_TOOLS_H___
#define ___INC_TIME_TOOLS_H___

#include <time.h>


typedef struct
{
	int Year;
	int Month;
	int Day;
	int Hour;
	int Minute;
	int Second;
	int Milliseconds;
	
}TTime;

void	Time_GetTimestamp(uint32 *pSec, uint32 *pMicroSec);

void	Time_GetUTCTime(TTime *Time);
void	Time_GetLocalTime(TTime *Time);

// returned time is in UTC for Time_GetTime() and Time_GetTime64()
#define Time_GetTime()	((uint32)time(NULL))
uint64	Time_GetTime64(TTime *Time);

uint32	Time_GetTick(void);
uint32	Time_GetMicroTick(void);	// this function returns in less than 10s, which should be taken in account

// diff functions: we suppose we missed 1 loop only
#define Time_GetElapsedTime(Base)	Time_Diff32(Time_GetTime(), Base)
#define Time_GetElapsedTick(Base)	Time_Diff32(Time_GetTick(), Base)
#define Time_Diff32(Now, Base)		((uint32)(((Now) < (Base)) ? (((uint32)0xffffffff) - (Base)) + (Now) : ((Now) - (Base))))

// if wait set to 1, tries to really sleep the whole duration, even if an event occurs
void	Time_SleepEx(uint32 Milliseconds, int Wait);
#define Time_Sleep(m)	Time_SleepEx(m, 0)	// don't wait by default
#endif
