#!/bin/sh

SCRIPT_PATH=$(dirname $0)
SCRIPT_NAME=$(basename $0)
SVN_REV=$(cat .svn/entries | awk 'NR == 4')
VERSION=$(cat VERSION | awk '{print $1}')
PKG_VERSION="$VERSION.$SVN_REV"
PKG_NAME=libshred
PKG_FULLNAME="$PKG_NAME-$PKG_VERSION"

usage() {
	echo "Usage: $SCRIPT_NAME [-s]"
	echo "Options:"
	echo "  -s       snapshot"
	echo "  -h       this help message"
}

DO_SNAPSHOT=
while getopts "sh" Option
do
	case $Option in
		s) DO_SNAPSHOT=1;;
		h) usage; exit 1;;
		*) usage; exit 1;;
	esac
done

SRC_PATH=$SCRIPT_PATH/..

if [ ! -f "$SRC_PATH/VERSION" ]; then
	echo "must run this script from the source root"
	exit 1
fi

if [ "$DO_SNAPSHOT" == "1" ]; then
	PKG_FULLNAME=$PKG_FULLNAME-snapshot
fi
echo "building $PKG_FULLNAME"

TMP_PATH=$SRC_PATH/.tmp/$PKG_FULLNAME

# first cleanup
rm -rf $SRC_PATH/.tmp
rm -rf $TMP_PATH
mkdir -p $TMP_PATH

# copy files
cp -a $SRC_PATH/* $TMP_PATH

cd $TMP_PATH

# second cleanup
rm -rf trash
find . -name '.svn' | xargs rm -rf
make clean

# build test
make

# unit test
make utest

# final cleanup
make clean

cd ..
PKG_ARCHIVE=$PKG_FULLNAME.tar.bz2
tar jcvf $PKG_ARCHIVE $PKG_FULLNAME
rm -rf $PKG_FULLNAME
mv $PKG_ARCHIVE ..
cd ..
rm -rf .tmp

echo "done: $PKG_ARCHIVE"
