#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


#define USAGE_TYPICAL	-1
#define USAGE_ARG_LIST	-2
#define USAGE_ARG_COUNT	-3


static char _ProgName[256] = {0};
static int _LastArgCount = 0;


static void CliParser_CommandUsage(TCliParserCommand *Commands, char *ProgName)
{
	printf("Usage:");
	if(ProgName)
		printf(" %s", ProgName);
	printf(" <command> [options]\n");
	printf("\n");
	
	while(Commands->Command)
	{
		if(Commands->Function)
		{
			printf("command: %s\n", Commands->Command);
			
			printf("  typical usage:");
			if(ProgName)
				printf(" %s", ProgName);
			printf(" %s ", Commands->Command);
			
			Commands->Function(NULL, USAGE_TYPICAL);
			printf("\n");
			
			Commands->Function(NULL, USAGE_ARG_COUNT);
			if(_LastArgCount > 0)
			{
				printf("  full options list:\n");
				Commands->Function(NULL, USAGE_ARG_LIST);
			}
			printf("\n");
		}
		Commands++;
	}
}


int CliParser_DoCommands(TCliParserCommand *Commands, char **Args, int lArgs, char *ProgName)
{
	char *Command;
	TCliParserCommand *pCommand;
	
	
	_ProgName[0] = 0;
	if(ProgName)
		snprintf(_ProgName, sizeof(_ProgName) - 1, "%s", ProgName);
	
	if(lArgs < 1)
	{
		//printf("!! show usage 1\n");
		// show usage
		//if(!(Mode & PARSER_MODE_NODISPLAY))
		//	Parser_Usage(Args[0], Commands);
		CliParser_CommandUsage(Commands, ProgName);
		return 0;
	}
	
	Command = Args[0];
	pCommand = Commands;
	while(pCommand->Command)
	{
		if(strcmp(Command, pCommand->Command) == 0)
		{
			if(!pCommand->Function)
			{
				//if(!(Mode & PARSER_MODE_NODISPLAY))
				printf("error: null function for built-in command '%s'\n", Command);
				return 0;
			}
			return pCommand->Function(Args + 1, lArgs - 1);
		}
		pCommand++;
	}
	
	//Parser_Usage(Args[0], Commands);
	//printf("!! show usage 2\n");
	CliParser_CommandUsage(Commands, ProgName);
	return 0;
}


static void _CliParser_OptionsUsageTypical(TCliParserOption *Options, char **Args, int lArgs)
{
	char *Tag;
	
	// usage
	while(Options->ShortTag || Options->LongTag)
	{
		Tag = Options->ShortTag;
		if(!Tag)
			Tag = Options->LongTag;
		
		if(!Options->Required)
			printf("[");
		
		if(Options->Type != ARG_TYPE_FLAG)
		{
			char *TypicalValue = Options->TypicalValue;
			if(!TypicalValue || !TypicalValue[0])
				TypicalValue = "...";
			printf("%s %s", Tag, TypicalValue);
		}
		else
		{
			printf("%s", Tag);
		}
		
		if(!Options->Required)
			printf("]");
		
		printf(" ");
		
		Options++;
	}
}


static void _CliParser_OptionsUsageList(TCliParserOption *Options, char **Args, int lArgs, int DoCount)
{
	char cRequired, *ShortTag, *LongTag;
	TCliParserOption *pOption;
	int TagLengthMax, ValueLengthMax, Length, nOptions;
	
	
	nOptions = 0;
	TagLengthMax = 0;
	ValueLengthMax = 0;
	pOption = Options;
	while(pOption->ShortTag || pOption->LongTag)
	{
		if(pOption->LongTag)
		{
			Length = strlen(pOption->LongTag);
			if(Length > TagLengthMax)
				TagLengthMax = Length;
		}
		if(pOption->TypicalValue)
		{
			Length = strlen(pOption->TypicalValue);
			if(Length > ValueLengthMax)
				ValueLengthMax = Length;
		}
		pOption++;
		nOptions++;
	}
	if(DoCount)
	{
		_LastArgCount = nOptions;
		return;
	}
	
	pOption = Options;
	while(pOption->ShortTag || pOption->LongTag)
	{
		cRequired = ' ';
		if(pOption->Required)
			cRequired = '*';
		
		ShortTag = pOption->ShortTag;
		if(!ShortTag)
			ShortTag = "  ";
		
		LongTag = pOption->LongTag;
		if(!LongTag)
			LongTag = "";
		
		printf("    %c %s %s", cRequired, ShortTag, LongTag);
		
		Length = strlen(pOption->LongTag);
		while(Length < TagLengthMax)
		{
			printf(" ");
			Length++;
		}
		
		printf(" ");
		Length = 0;
		if(pOption->Type != ARG_TYPE_FLAG && pOption->TypicalValue)
		{
			printf("%s", pOption->TypicalValue);
			Length = strlen(pOption->TypicalValue);
		}
		
		while(Length < ValueLengthMax)
		{
			printf(" ");
			Length++;
		}
		
		printf("   (%s)\n", pOption->Description);
		
		pOption++;
	}
}


int CliParser_DoOptions(TCliParserOption *Options, char **Args, int lArgs)
{
	int i, iArgs, Match;
	TCliParserOption *Option;
	char *Tag;
	
	
	if((lArgs < 0 || !Args) /*&& !(Mode & PARSER_MODE_NODISPLAY)*/)
	{
		switch(lArgs)
		{
			case USAGE_TYPICAL:
				_CliParser_OptionsUsageTypical(Options, Args, lArgs);
				break;
			case USAGE_ARG_LIST:
				_CliParser_OptionsUsageList(Options, Args, lArgs, 0);
				break;
			case USAGE_ARG_COUNT:
				_CliParser_OptionsUsageList(Options, Args, lArgs, 1);
				break;
			default:
				break;
		}
		return 0;
	}
	
	
	// load arguments
	i = 0;
	iArgs = 0;
	while(1)
	{
		// all arguments processed
		if(iArgs >= lArgs)
			break;
		
		Match = 0;
		Option = &Options[i];
		
		Tag = Args[iArgs];
		
		if(!Option->ShortTag && !Option->LongTag)
		{
			if(!(strcmp(Tag, "-h") == 0 || strcmp(Tag, "--help") == 0))
			{
				//if(!(Mode & PARSER_MODE_NODISPLAY))
					printf("error: unknown option '%s'\n", Tag);
			}
			_CliParser_OptionsUsageList(Options, Args, lArgs, 0);
			printf("\n");
			return 0;
		}
		
		if(Option->ShortTag)
		{
			if(strcmp(Tag, Option->ShortTag) == 0)
				Match = 1;
		}
		if(Option->LongTag)
		{
			if(strcmp(Tag, Option->LongTag) == 0)
				Match = 1;
		}
		
		if(Match)
		{
			switch(Option->Type)
			{
				case ARG_TYPE_STRING:
				{
					char **pMem;
					
					if(!Option->pMem)
					{
						//if(!(Mode & PARSER_MODE_NODISPLAY))
							printf("error: null memory pointer\n");
						return 0;
					}
					if(iArgs + 1 >= lArgs)
					{
						//if(!(Mode & PARSER_MODE_NODISPLAY))
						{
							printf("error: value missing for option %s\n", Tag);
							_CliParser_OptionsUsageList(Options, Args, lArgs, 0);
							printf("\n");
						}
						return 0;
					}
					pMem = (char**)Option->pMem;
					*pMem = Args[iArgs + 1];
					Option->Set = 1;
					// next
					i = 0;
					iArgs += 2;
					break;
				}
				
				case ARG_TYPE_INT:
				{
					int *pMem;
					
					if(!Option->pMem)
					{
						//if(!(Mode & PARSER_MODE_NODISPLAY))
							printf("error: null memory pointer\n");
						return 0;
					}
					if(iArgs + 1 >= lArgs)
					{
						//if(!(Mode & PARSER_MODE_NODISPLAY))
						{
							printf("error: value missing for option %s\n", Tag);
							_CliParser_OptionsUsageList(Options, Args, lArgs, 0);
							printf("\n");
						}
						return 0;
					}
					pMem = (int*)Option->pMem;
					*pMem = atoi(Args[iArgs + 1]);
					Option->Set = 1;
					// next
					i = 0;
					iArgs += 2;
					break;
				}
				
				case ARG_TYPE_FLAG:
				{
					int *pMem;
					
					if(!Option->pMem)
					{
						//if(!(Mode & PARSER_MODE_NODISPLAY))
							printf("error: null memory pointer\n");
						return 0;
					}
					
					pMem = (int*)Option->pMem;
					*pMem = 1;
					Option->Set = 1;
					// next
					i = 0;
					iArgs += 1;
					break;
				}
				
				default:
					break;
			}
		}
		else
		{
			i++;
		}
	}
	
	// check required arguments
	i = 0;
	while(1)
	{
		Option = &Options[i];
		
		if(!Option->ShortTag && !Option->LongTag)
			break;
		
		Tag = Option->ShortTag;
		if(!Tag)
			Tag = Option->LongTag;
		
		if(Option->Required && !Option->Set)
		{
			//if(!(Mode & PARSER_MODE_NODISPLAY))
			{
				printf("error: missing required option %s\n", Tag);
				_CliParser_OptionsUsageList(Options, Args, lArgs, 0);
				printf("\n");
			}
			return 0;
		}
		
		i++;
	}
	
	return 1;
}
