#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <unistd.h>
#include <fcntl.h>

#include <libshred.h>


#if defined(LINUX) || defined(APPLE) || defined(FREEBSD)
int Process_SetCloseOnExec(int FD)
{
	int Flags;
	
	Flags = fcntl(FD, F_GETFD);
	if(Flags == -1)
	{
		LOG_DEBUG("error: fcntl(F_GETFD)");
		return 0;
	}
	
	Flags |= FD_CLOEXEC;
	if (fcntl(FD, F_SETFD, Flags) == -1)
	{
		LOG_DEBUG("error: fcntl(F_SETFD)");
		return 0;
	}
	
	return 1;
}
#endif
