#ifndef ___INC_UNIT_TEST_H___
#define ___INC_UNIT_TEST_H___

#include <libshred.h>

typedef int (*TTestCaseRunClbk)(void *Param);
typedef void (*TTestCaseGetInfoClbk)(void *Param, char *Info, int szInfo);

typedef struct
{
	char *	Name;
	TArray *TestCases;
	
}TTestSuite;

typedef struct
{
	char *					Info;
	TTestCaseGetInfoClbk	GetInfo;	// set only if Info is not set
	TTestCaseRunClbk		Run;
	void *					Param;
	int						ExpectedResult;
	int						Result;		// manual set, if Run() is NULL
	
}TTestCase;


TTestSuite *	TestSuite_Create(char *Name);
void			TestSuite_Destroy(TTestSuite *TestSuite);
void			TestSuite_AddTestCase(TTestSuite *TestSuite, char *Info, TTestCaseGetInfoClbk GetInfoClbk, TTestCaseRunClbk RunClbk, void *Param, int ExpectedResult);
void			TestSuite_SetTestCase(TTestSuite *TestSuite, char *Info, int Success);
int				TestSuite_Run(TTestSuite *TestSuite);

#endif
