#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

#include <UnitTest.h>


int HasChildTLV(uint32 ID)
{
	switch(ID)
	{
		case TLV_FOURCC('b', 'u', 'f', 0):
			return 1;
		
		case TLV_FOURCC('s', 't', 'r', 0):
		case TLV_FOURCC('u', '8', 0, 0):
		case TLV_FOURCC('u', '1', '6', 0):
		case TLV_FOURCC('u', '3', '2', 0):
			return 0;
		
		default:
			return -1;
	}
}


int main(void)
{
	{
		uint8 *Buffer;
		int szBuffer;
		
		TLV_Buffer_Prepare(&Buffer, &szBuffer);
		TLV_Append_String(&Buffer, &szBuffer, TLV_FOURCC('s', 't', 'r', 0), "parent");
		
		{
			uint8 *Buffer2;
			int szBuffer2;
			
			TLV_Buffer_Prepare(&Buffer2, &szBuffer2);
			TLV_Append_String(&Buffer2, &szBuffer2, TLV_FOURCC('s', 't', 'r', 0), "child");
			TLV_Append_UInt8(&Buffer2, &szBuffer2, TLV_FOURCC('u', '8', 0, 0), (uint8)12);
			TLV_Append_UInt16(&Buffer2, &szBuffer2, TLV_FOURCC('u', '1', '6', 0), (uint16)1234);
			TLV_Append_UInt32(&Buffer2, &szBuffer2, TLV_FOURCC('u', '3', '2', 0), (uint32)12345678);
			
			// add child twice
			TLV_Append_Buffer(&Buffer, &szBuffer, TLV_FOURCC('b', 'u', 'f', 0), Buffer2, szBuffer2);
			TLV_Append_Buffer(&Buffer, &szBuffer, TLV_FOURCC('b', 'u', 'f', 0), Buffer2, szBuffer2);
			
			TLV_Buffer_Cleanup(&Buffer2, &szBuffer2);
		}
		
		// add payload
		szBuffer += 15;
		Buffer = realloc(Buffer, szBuffer);
		
		TLV_Dump(Buffer, szBuffer, HasChildTLV);
		
		TLV_Buffer_Cleanup(&Buffer, &szBuffer);
	}
	
	return 0;
}
