#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


//#define SIZE	1024
#define SIZE	72073	// Centered heptagonal prime: of the form (7n^2 - 7n + 2) / 2

static int SortOrder = 1;


static void Numbers_CheckSorted(int *Numbers, int lNumbers)
{
	int i, iMax;
	
	iMax = lNumbers - 1;
	for(i=0;i<iMax;i++)
	{
		if(Numbers[i] > Numbers[i + 1])
		{
			printf("check sort: mismatch at index %d\n", i);
			return;
		}
	}
	printf("check sort: match\n");
}


static void Numbers_ResetData(int *Numbers, int lNumbers)
{
	int i;
	
	srand(777);
	for(i=0;i<lNumbers;i++)
		Numbers[i] = ((((uint32)rand()) % 34543 + 1) * (((uint32)rand()) % 19 + 1) - 1);
}


static int ComparisonCallback1(void *pArg0, void *pArg1, void *pData)
{
	int *pInt0 = (int*)pArg0;
	int *pInt1 = (int*)pArg1;
	int *pOrder = (int*)pData;
	return (*pOrder) * ((*pInt0) - (*pInt1));
}


static int ComparisonCallback2(void *pArg0, void *pArg1)
{
	int *pInt0 = (int*)pArg0;
	int *pInt1 = (int*)pArg1;
	int *pOrder = &SortOrder;
	return (*pOrder) * ((*pInt0) - (*pInt1));
}


int main(void)
{
	int Numbers[SIZE];
	uint32 dwStart;
	int TickElapsed;
	
	{
		printf("heapsort asc test\n");
		Numbers_ResetData(Numbers, SIZE);
		SortOrder = 1;
		
		dwStart = Time_GetTick();
		Sort_HeapSort(Numbers, SIZE, sizeof(int), ComparisonCallback1, (void*)&SortOrder);
		TickElapsed = (int)Time_GetElapsedTick(dwStart);
		
		Numbers_CheckSorted(Numbers, SIZE);
		printf("time elapsed: %d ms\n", TickElapsed);
		printf("\n");
	}
	
	{
		printf("heapsort desc test\n");
		Numbers_ResetData(Numbers, SIZE);
		SortOrder = -1;
		
		dwStart = Time_GetTick();
		Sort_HeapSort(Numbers, SIZE, sizeof(int), ComparisonCallback1, (void*)&SortOrder);
		TickElapsed = (int)Time_GetElapsedTick(dwStart);
		
		Numbers_CheckSorted(Numbers, SIZE);
		printf("time elapsed: %d ms\n", TickElapsed);
		printf("\n");
	}
	
	{
		printf("qsort asc test\n");
		Numbers_ResetData(Numbers, SIZE);
		SortOrder = 1;
		
		dwStart = Time_GetTick();
		qsort(Numbers, SIZE, sizeof(int), (int (*)(const void *, const void *))ComparisonCallback2);
		TickElapsed = (int)Time_GetElapsedTick(dwStart);
		
		Numbers_CheckSorted(Numbers, SIZE);
		printf("time elapsed: %d ms\n", TickElapsed);
		printf("\n");
	}
	
	{
		printf("qsort desc test\n");
		Numbers_ResetData(Numbers, SIZE);
		SortOrder = -1;
		
		dwStart = Time_GetTick();
		qsort(Numbers, SIZE, sizeof(int), (int (*)(const void *, const void *))ComparisonCallback2);
		TickElapsed = (int)Time_GetElapsedTick(dwStart);
		
		Numbers_CheckSorted(Numbers, SIZE);
		printf("time elapsed: %d ms\n", TickElapsed);
		printf("\n");
	}
	
	return 0;
}
