#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

#ifndef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif


typedef struct
{
	int		ParentPID;
	char *	BinName;
	int		Cleaned;
	
}TWatcherParam;


static int WatcherThread(void *Handle, void *Data)
{
	TWatcherParam *Param = (TWatcherParam*)Data;
	uint32 uTimeStart;
	int DoCleanup = 0;
	//int ParentPID = Param->ParentPID;
	char *BinName = Param->BinName;
	
	
	uTimeStart = Time_GetTime();
	while(1)
	{
		if(Time_GetElapsedTime(uTimeStart) >= 3)
		{
			DoCleanup = 1;
			break;
		}
		
		if(Thread_Slave_GetCloseEvent(Handle))
			break;
		
		Time_Sleep(10);
	}
	
	if(DoCleanup)
	{
		LOG_DEBUG("cleanup for %s", BinName);
#ifdef WIN32
		System_ExecuteArgs("taskkill /F /IM %s > NUL 2>&1", BinName);
#else
		System_ExecuteArgs("killall %s > /dev/null 2>&1", BinName);
#endif
		Param->Cleaned = 1;
	}
	
	return 0;
}


static int RunUnitTest(char *BinName)
{
	TWatcherParam Param;
	int Done = 0;
	void *Thread = NULL;
	
	
	memset(&Param, 0, sizeof(Param));
	Param.ParentPID = System_GetPID();
	Param.BinName = BinName;
	
	// start watcher thread
	Thread = Thread_Master_Open(WatcherThread, &Param);
	
	// start test
#ifdef WIN32
	Done = System_ExecuteArgs("%s > NUL 2>&1", BinName);
#else
	Done = System_ExecuteArgs("./%s > /dev/null 2>&1", BinName);
#endif
	
	// join watcher thread
	Thread_Master_SetCloseEvent(Thread);
	Thread_Master_WaitThreadTermination(Thread, 10, 1);
	Thread_Master_Close(Thread);
	
	// return accordingly
	if(!Param.Cleaned)
		return Done;
	return 0;
}


#define TEST_REPEAT		100


int main(int nArgs, char **Args)
{
	char BinPath[256], BinName[64];
	int lBinPath, lBinName;
	char **Files = NULL;
	int i, lFiles = 0;
	
	
	//System_SetDebug(1);
	
	BinPath[0] = 0;
	lBinPath = sizeof(BinPath);
	BinName[0] = 0;
	lBinName = sizeof(BinName);
	FileSystem_SplitDirFileName(Args[0], BinPath, &lBinPath, BinName, &lBinName);
	
	LOG_DEBUG("processing utests in path %s", BinPath);
	
	FileSystem_ChangeDir(BinPath);
	
#ifdef WIN32
	// win32: only list .exe files
	if(FileSystem_GetFilesInDir(BinPath, "utest_*.exe", &Files, &lFiles))
#else
	if(FileSystem_GetFilesInDir(BinPath, "utest_*", &Files, &lFiles))
#endif
	{
		for(i=0;i<lFiles;i++)
		{
			char *File = Files[i];
			int j;
			
#ifndef WIN32
			{
				struct stat Stat;
				int iPos;
				
				// *nix: skip .c, .o, ...
				iPos = String_IndexOf(File, '.');
				if(iPos > 0)
					continue;
				
				// *nix: really check for executable condition
				if(stat(File, &Stat) != 0)
					continue;
				
				if(access(File, F_OK | X_OK) != 0)
					continue;
			}
#endif
			// skip ourself
			if(String_EndsWith(File, BinName))
				continue;
			
			LOG_DEBUG("processing utest [%s]", File);
			
			for(j=0;j<TEST_REPEAT;j++)
			{
				if(!RunUnitTest(File))
				{
					LOG_DEBUG("===> error");
					break;
				}
			}
		}
		StringArray_Free(&Files, &lFiles);
	}
	
	return 0;
}
