#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int main(int nArgs, char **Args)
{
	char *ProgName;
	char ProgPath[256];
	
	
	if(nArgs <= 1)
	{
		printf("Usage: %s <command>\n", Args[0]);
		return 1;
	}
	ProgName = Args[1];
	
	
	// resolv full path
	ProgPath[0] = 0;
	if(ProgName[0] == '.' || ProgName[0] == '/')
	{
		// resolv relative path, or just test it
		int lProgPath = sizeof(ProgPath);
		if(!FileSystem_RealPathEx(ProgName, NULL, ProgPath, &lProgPath, 1))
			ProgPath[0] = 0;
	}
	else
	{
		// resolv using path
		char *Path = getenv("PATH");
		if(Path)
		{
			char **Paths = NULL;
			int lPaths = 0;
			
			if(String_Split(Path, ':', &Paths, &lPaths))
			{
				char TmpPath[256];
				int i, lProgPath;
				
				for(i=0;i<lPaths;i++)
				{
					snprintf(TmpPath, sizeof(TmpPath) - 1, "%s/%s", Paths[i], ProgName);
					lProgPath = sizeof(ProgPath);
					if(FileSystem_RealPathEx(TmpPath, NULL, ProgPath, &lProgPath, 1))
						break;
				}
				StringArray_Free(&Paths, &lPaths);
			}
		}
	}
	
	if(!ProgPath[0])
	{
		char *Path = getenv("PATH");
		if(!Path)
			Path = "";
		fprintf(stderr, "error: program not found in path [%s]: %s\n", Path, ProgName);
		return 2;
	}
	
	System_Daemonize();
	
	return execv(ProgPath, Args + 1);
}
