#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int main(int nArgs, char **Args)
{
	char *Filename = NULL;
	
	if(nArgs != 2)
	{
		LOG_DEBUG("Usage: %s <file>", Args[0]);
		return 0;
	}
	Filename = Args[1];
	
	LOG_DEBUG("file info on file %s", Filename);
	if(!FileSystem_FileExists(Filename))
	{
		LOG_DEBUG("file not found");
	}
	else
	{
		uint64 Size = FileSystem_FileSize(Filename);
		
#ifdef WIN32
		LOG_DEBUG("file size: %I64d B, %d MB", Size, (int)(Size / (1024ll * 1024ll)));
#else
		LOG_DEBUG("file size: %lld B, %d MB", Size, (int)(Size / (1024ll * 1024ll)));
#endif
		
		// todo: md5sum, sha1sum
	}
	
	return 0;
}
