#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


void PrintHash_CRC32(uint8 *Data, int lData)
{
	char StringDigest[20];
	uint32 Hash;
	
	Hash = Hash_CRC32(Data, lData);
	Hash_UINT32_DigestToString(Hash, StringDigest);
	
	LOG_DEBUG("CRC32:  %s", StringDigest);
}

void PrintHash_SQLITE(uint8 *Data, int lData)
{
	char StringDigest[20];
	uint32 Hash;
	
	Hash = Hash_SQLITE(Data, lData);
	Hash_UINT32_DigestToString(Hash, StringDigest);
	
	LOG_DEBUG("SQLITE: %s", StringDigest);
}

void PrintHash_MD5(uint8 *Data, int lData)
{
	uint8 RawDigest[MD5_DIGEST_SIZE];
	char StringDigest[MD5_DIGEST_STRING_SIZE];
	void *Ctx;
	
	Ctx = Hash_MD5_Init();
	Hash_MD5_Update(Ctx, Data, lData);
	Hash_MD5_Final(Ctx, RawDigest);
	Hash_MD5_DigestToString(RawDigest, StringDigest);
	
	LOG_DEBUG("MD5:    %s", StringDigest);
}

void PrintHash_SHA1(uint8 *Data, int lData)
{
	uint8 RawDigest[SHA1_DIGEST_SIZE];
	char StringDigest[SHA1_DIGEST_STRING_SIZE];
	void *Ctx;
	
	Ctx = Hash_SHA1_Init();
	Hash_SHA1_Update(Ctx, Data, lData);
	Hash_SHA1_Final(Ctx, RawDigest);
	Hash_SHA1_DigestToString(RawDigest, StringDigest);
	
	LOG_DEBUG("SHA1:   %s", StringDigest);
}


int main(int nArgs, char **Args)
{
	char *HashMode = NULL;
	char *Input = NULL;
	TCliParserOption Options[] = {
		{"-m", "--hash-mode", "hash mode/function", "crc32,sqlite,md5,sha1", &HashMode, ARG_TYPE_STRING, 0},
		{"-i", "--input", "string or file", "string:anystring|file:anyfile", &Input, ARG_TYPE_STRING, 1},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	uint8 *Data = NULL;
	int lData = 0;
	int Success = 0;
	
	
	if(!CliParser_DoOptions(Options, Args + 1, nArgs - 1))
		return 0;
	
	{
		char *Trail;
		
		if(String_StartsWithEx(Input, "string:", &Trail))
		{
			Data = (uint8*)strdup(Trail);
			lData = strlen(Trail);
			
			LOG_DEBUG("input: string, size: %d", lData);
		}
		else if(String_StartsWithEx(Input, "file:", &Trail))
		{
			char *Filename = Trail;
			
			if(!FileSystem_FileExists(Filename))
			{
				LOG_DEBUG("error: file not found: %s", Filename);
				return 1;
			}
			
			lData = FileSystem_FileSize(Filename);
			Data = malloc(lData);
			
			if(!FileSystem_FileToBuffer(Filename, Data, &lData))
			{
				LOG_DEBUG("error: reading file: %s", Filename);
				free(Data);
				return 1;
			}
			
			LOG_DEBUG("input: file, size: %d", lData);
		}
		else
		{
			LOG_DEBUG("error: invalid input: %s", Input);
			return 1;
		}
	}
	
	if(!HashMode || strcmp(HashMode, "crc32") == 0)
		PrintHash_CRC32(Data, lData);
	if(!HashMode || strcmp(HashMode, "sqlite") == 0)
		PrintHash_SQLITE(Data, lData);
	if(!HashMode || strcmp(HashMode, "md5") == 0)
		PrintHash_MD5(Data, lData);
	if(!HashMode || strcmp(HashMode, "sha1") == 0)
		PrintHash_SHA1(Data, lData);
	
	if(Data)
		free(Data);
	
	return System_SuccessToExitCode(Success);
}
