#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


static uint8 Rand_UINT8(void)
{
	int n1, n2;
	
	// get 2 distinct numbers
	do
	{
		n1 = rand();
		n2 = rand();
		
	} while(n1 == n2);
	
	// reorder n2 > n1
	if(n1 > n2)
	{
		int t;
		
		t = n1;
		n1 = n2;
		n2 = t;
	}
	
	return (uint8)((((n1 + n2) / (n2 - n1) + (n2 * n2 - n1 * n1)) & 0x7fffffff) % 256);
}


static void ReallocFill(uint8 **pBuffer, int szBuffer)
{
	uint8 uFill = Rand_UINT8();
	
	//LOG_DEBUG("ReallocFill(%p, %d), uFill=%d", pBuffer, szBuffer, uFill);
	*pBuffer = realloc(*pBuffer, szBuffer);
	memset(*pBuffer, uFill, szBuffer);
}


int Cmd_Fill(char **Args, int nArgs)
{
	char *Shape = NULL;
	int Range = 0;
	int Time = 0;
	int DoLoop = 0;
	TCliParserOption Options[] = {
		{"-s", "--shape", "shape to use", "fixed|line", &Shape, ARG_TYPE_STRING, 1},
		{"-r", "--range", "range for shape", "32", &Range, ARG_TYPE_INT, 1},
		{"-t", "--time", "time for 1 loop", "10", &Time, ARG_TYPE_INT, 0},
		{"-l", "--loop", "do infinite loop", "", &DoLoop, ARG_TYPE_FLAG, 0},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	uint8 *Buffer = NULL;
	int szBuffer = 0;
	
	
	if(!CliParser_DoOptions(Options, Args, nArgs))
		return 0;
	
	srand(Time_GetTime());
	
	if(strcmp(Shape, "line") == 0)
	{
		int i, iLoop, Resolution;
		
		if(Time <= 0)
			Time = 10;
		
		iLoop = 0;
		Resolution = 100;
		do
		{
			for(i=1;i<=Resolution;i++)
			{
				szBuffer = (int)(((uint64)i * (uint64)Range) / (uint64)Resolution);
				ReallocFill(&Buffer, szBuffer);
				Time_Sleep((Time * 1000) / Resolution);
			}
			iLoop++;
			
			LOG_DEBUG("done loop %d", iLoop);
			
		} while(DoLoop);
	}
	else if(strcmp(Shape, "fixed") == 0)
	{
		ReallocFill(&Buffer, Range);
		
		while(1)
		{
			if(Time > 0)
			{
				Time_Sleep(Time * 1000);
				break;
			}
			Time_Sleep(5000);
		}
	}
	else
	{
		LOG_ERROR("error: invalid shape: %s", Shape);
	}
	
	LOG_DEBUG("done");
	
	if(Buffer)
		free(Buffer);
	
	return 0;
}


int main(int nArgs, char **Args)
{
	TCliParserCommand Commands[] = {
		{"fill", Cmd_Fill},
		{NULL, NULL}
	};
	
	return CliParser_DoCommands(Commands, Args + 1, nArgs - 1, Args[0]);
}
