#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

#define MAX_IP_POOL		512


typedef struct
{
	void *	Thread;
	char	IP[32];
	uint32	dwIP;
	int		IsAlive;
	
}TPingProcess;


static int Thread_PingProc(void *pThread, void *Data)
{
	TPingProcess *pProcess = (TPingProcess*)Data;
	
#ifdef WIN32
	pProcess->IsAlive = System_ExecuteArgs("ping -n 1 -w 1000 %s > NUL 2>&1", pProcess->IP);
#else
	pProcess->IsAlive = System_ExecuteArgs("ping -c 1 -w 1 %s > /dev/null 2>&1", pProcess->IP);
#endif
	
	return 0;
}


int main(int nArgs, char **Args)
{
	char *Interface = NULL;
	int DoAddMAC = 0;
	TCliParserOption Options[] = {
		{"-i", "--interface", "interface to bind to", "eth0", &Interface, ARG_TYPE_STRING, 1},
		{"-m", "--mac", "add MAC address from ARP table to result", "", &DoAddMAC, ARG_TYPE_FLAG, 0},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	TInterfaceInfo *IPInfo = NULL;
	int szIPInfo = 0;
	
	if(!CliParser_DoOptions(Options, Args + 1, nArgs - 1))
		return 0;
	
	if(IP_GetInterfaceTable(&IPInfo, &szIPInfo))
	{
		TInterfaceInfo *pIfInfo = IP_GetInterface(IPInfo, szIPInfo, Interface);
		if(pIfInfo)
		{
			uint32 dwNetwork, dwBroadcast, dwFirstIP, dwLastIP, dwGw;
			int nIP = 0;
			char MAC[32], IP[32], Netmask[32], Network[32], Broadcast[32], FirstIP[32], LastIP[32], Gw[32];
			
			
			dwGw = IP_GetDefaultGateway();
			IP_Uint32ToIP(dwGw, Gw, sizeof(Gw));
			
			IP_MACToString(pIfInfo->bMAC, MAC, sizeof(MAC));
			IP_Uint32ToIP(pIfInfo->dwIP, IP, sizeof(IP));
			IP_Uint32ToIP(pIfInfo->dwNetmask, Netmask, sizeof(Netmask));
			
			dwNetwork = IP_GetNetworkAddr(pIfInfo->dwIP, pIfInfo->dwNetmask);
			dwBroadcast = IP_GetBroadcastAddr(pIfInfo->dwIP, pIfInfo->dwNetmask);
			IP_Uint32ToIP(dwNetwork, Network, sizeof(Network));
			IP_Uint32ToIP(dwBroadcast, Broadcast, sizeof(Broadcast));
			
			dwFirstIP = IP_GetFirstAddr(pIfInfo->dwIP, pIfInfo->dwNetmask);
			dwLastIP = IP_GetLastAddr(pIfInfo->dwIP, pIfInfo->dwNetmask);
			nIP = (int)(dwLastIP - dwFirstIP + 1);
			IP_Uint32ToIP(dwFirstIP, FirstIP, sizeof(FirstIP));
			IP_Uint32ToIP(dwLastIP, LastIP, sizeof(LastIP));
			
			LOG_DEBUG("info: gateway:           %s", Gw);
			LOG_DEBUG("info: interface %s", Interface);
			LOG_DEBUG("info:   mac:             %s", MAC);
			LOG_DEBUG("info:   ip:              %s", IP);
			LOG_DEBUG("info:   netmask:         %s (/%d)", Netmask, IP_NetmaskToCidr(pIfInfo->dwNetmask));
			LOG_DEBUG("info:   network:         %s", Network);
			LOG_DEBUG("info:   broadcast:       %s", Broadcast);
			LOG_DEBUG("info:   first net ip:    %s", FirstIP);
			LOG_DEBUG("info:   last net ip:     %s", LastIP);
			LOG_DEBUG("info:   number of ip:    %d", nIP);
			
			if(nIP > 0)
			{
				if(nIP > MAX_IP_POOL)
				{
					LOG_ERROR("error: too many IP to ping, limited to %d", MAX_IP_POOL);
				}
				else
				{
					TPingProcess *Threads = NULL;
					int i;
					
					Threads = malloc(nIP * sizeof(TPingProcess));
					memset(Threads, 0, nIP * sizeof(TPingProcess));
					
					// prepare data
					for(i=0;i<nIP;i++)
					{
						TPingProcess *pThread = &Threads[i];
						pThread->dwIP = dwFirstIP + (uint32)i;
						IP_Uint32ToIP(pThread->dwIP, pThread->IP, sizeof(pThread->IP));
					}
					
					// start pings
					for(i=0;i<nIP;i++)
					{
						TPingProcess *pThread = &Threads[i];
						
						//if(dwIP != dwGw)
						pThread->Thread = Thread_Master_Open(Thread_PingProc, (void*)pThread);
						
						// slow down thread creation
						if(i > 0 && i % 10 == 0)
						{
							int j;
							
							Time_Sleep(150);
							
							// collect all terminated threads
							for(j=0;j<i;j++)
							{
								TPingProcess *pThread2 = &Threads[j];
								
								if(pThread2->Thread && Thread_Master_WaitThreadTermination(pThread2->Thread, 0, 0))
								{
									Thread_Master_Close(pThread2->Thread);
									pThread2->Thread = NULL;
									//LOG_DEBUG("thread %d closed [0]", j);
								}
							}
						}
					}
					
					// wait a bit
					Time_Sleep(200);
					
					for(i=0;i<nIP;i++)
					{
						TPingProcess *pThread = &Threads[i];
						
						if(pThread->Thread)
						{
							Thread_Master_WaitThreadTermination(pThread->Thread, 100, 1);
							Thread_Master_Close(pThread->Thread);
							pThread->Thread = NULL;
							//LOG_DEBUG("thread %d closed [1]", i);
						}
					}
					
					// summary
					{
						TARPInfo *ARPInfo = NULL;
						int szARPInfo = 0;
						
						if(DoAddMAC)
							IP_GetARPTable(&ARPInfo, &szARPInfo);
						
						for(i=0;i<nIP;i++)
						{
							TPingProcess *pThread = &Threads[i];
							char MAC[32];
							
							MAC[0] = 0;
							if(ARPInfo)
							{
								int j;
								for(j=0;j<szARPInfo;j++)
								{
									if(ARPInfo[j].dwIP == pThread->dwIP)
									{
										IP_MACToString(ARPInfo[j].bMAC, MAC, sizeof(MAC));
										break;
									}
								}
							}
							
							if(pThread->IsAlive)
							{
								if(!MAC[0])
									LOG_DEBUG("%s is alive", pThread->IP);
								else
									LOG_DEBUG("%s is alive [%s]", pThread->IP, MAC);
							}
						}
						
						if(ARPInfo)
							free(ARPInfo);
					}
					
					free(Threads);
				}
			}
		}
		IP_FreeInterfaceTable(IPInfo, szIPInfo);
	}
	return 0;
}
