#####
# default binaries
#
CROSS_COMPILE =
CC = $(CROSS_COMPILE)gcc
CXX = $(CROSS_COMPILE)g++
LD = $(CROSS_COMPILE)ld
STRIP = $(CROSS_COMPILE)strip
AR = $(CROSS_COMPILE)ar
NM = $(CROSS_COMPILE)nm



#####
# OS context switcher
#
ifeq ($(OS_TYPE),)
$(warning OS not found, try to auto-detect)
	OS_ENV_WIN32		:= 0
	OS_ENV_FREEBSD		:= 0
	OS_ENV_LINUX		:= 0
	OS_ENV_MINGW		:= 0
	OS_ENV_APPLE		:= 0
	OS_ENV_BIG_ENDIAN	:= 0
	OS_ENV_CYGWIN		:= 0
	OS_ENV_OSX			:= 0
	OS_BITS             := 32
	
	ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "mingw")),)
$(warning found MinGW)
		OS_ENV_WIN32 = 1
		OS_ENV_MINGW = 1
		
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "x86_64")),)
			OS_BITS = 64
		endif
	else
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep -i "linux")),)
$(warning found Linux)
			OS_ENV_LINUX = 1
		endif
		
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "FreeBSD")),)
$(warning found FreeBSD)
			OS_ENV_FREEBSD = 1
		endif
		
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "target=powerpc")),)
$(warning found Apple PowerPC)
			OS_ENV_APPLE = 1
			OS_ENV_BIG_ENDIAN = 1
		endif
		
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "Apple Computer, Inc")),)
$(warning found Apple OSX)
			OS_ENV_APPLE = 1
			OS_ENV_OSX = 1
		endif

		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "apple-darwin9")),)
$(warning found Apple OSX)
			OS_ENV_APPLE = 1
			OS_ENV_OSX = 1
		endif
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "apple-darwin10")),)
$(warning found Apple OSX)
			OS_ENV_APPLE = 1
			OS_ENV_OSX = 1
		endif
		
		ifneq ($(strip $(shell $(CC) -v 2>&1 | grep "cygming")),)
$(warning found Cygwin)
			OS_ENV_CYGWIN = 1
		endif
	endif
	
	ifeq ($(OS_FOUND),0)
$(error OS not detected)
	else
		ifeq ($(OS_ENV_WIN32),1)
			OS_TYPE = WIN32
		endif
		ifeq ($(OS_ENV_LINUX),1)
			OS_TYPE = LINUX
		endif
		ifeq ($(OS_ENV_APPLE),1)
			OS_TYPE = APPLE
		endif
		ifeq ($(OS_ENV_FREEBSD),1)
			OS_TYPE = FREEBSD
		endif
		ifeq ($(OS_ENV_BIG_ENDIAN),1)
			DEFS_FLAGS	+= -DSYS_BIG_ENDIAN
		endif
	endif
endif

# default
NULL_FILE=/dev/null
DLL_EXT=.so

# OS dependent
ifeq ($(OS_TYPE),WIN32)
	NET_LIB		= -lws2_32 -liphlpapi
	SYSTEM_LIB	= -lversion
	BIN_EXT		= .exe
	DLL_EXT		= .dll
	DEFS_FLAGS	+= -DWIN32
	STRIP_OPT	= --strip-debug --strip-unneeded
	NULL_FILE	= NUL
endif
ifeq ($(OS_TYPE),LINUX)
	THREAD_LIB	= -lpthread -lrt
	MATH_LIB	= -lm
	TIME_LIB	= -lrt
	DEFS_FLAGS	+= -DLINUX -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE
	STRIP_OPT	= --strip-debug --strip-unneeded
endif
ifeq ($(OS_TYPE),APPLE)
	THREAD_LIB	= -lpthread
	MATH_LIB	= -lm
	TIME_LIB	= 
	DEFS_FLAGS	+= -DAPPLE -arch i386 -arch x86_64 -arch ppc
	#DEFS_FLAGS	+= -DAPPLE -arch ppc64
	STRIP_OPT	= 
endif
ifeq ($(OS_TYPE),FREEBSD)
	THREAD_LIB	= -lpthread
	MATH_LIB	= -lm
	TIME_LIB	= 
	DEFS_FLAGS	+= -DFREEBSD
	STRIP_OPT	= --strip-debug --strip-unneeded
endif

export OS_TYPE
export OS_BITS
export NET_LIB
export SYSTEM_LIB
export THREAD_LIB
export MATH_LIB
export TIME_LIB
export DEFS_FLAGS
export STRIP_OPT
export BIN_EXT
export DLL_EXT
export NULL_FILE
