#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int Cmd_Cmd1(char **Args, int lArgs)
{
	char *String = NULL;
	int Int = 0;
	int Flag = 0;
	int Help = 0;
	TCliParserOption Options[] = {
		{"-s", "--string", "string", "some string", &String, ARG_TYPE_STRING, 1},
		{"-i", "--int", "int", "some int", &Int, ARG_TYPE_INT, 1},
		{"-f", "--flag", "flag", "", &Flag, ARG_TYPE_FLAG, 0},
		{"-h", "--hype", "something to discard help short tag", "", &Help, ARG_TYPE_FLAG, 0},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	
	if(!CliParser_DoOptions(Options, Args, lArgs))
		return 0;
	
	printf("string:  [%s]\n", String);
	printf("int:     [%d]\n", Int);
	printf("flag:    [%d]\n", Flag);
	
	return 0;
}


#if 1

// main with commands

int main(int nArgs, char **Args)
{
	TCliParserCommand Commands[] = {
		{"cmd1", Cmd_Cmd1},
		{"cmd2", Cmd_Cmd1},
		{NULL, NULL}
	};
	
	return CliParser_DoCommands(Commands, Args + 1, nArgs - 1, Args[0]);
}

#else

// main without commands

#endif

/*
	./sample_cliparser cmd1m
	./sample_cliparser cmd1
	./sample_cliparser
	
	./sample_cliparser cmd1 -s pouet
*/
