#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int ThreadFunction(void *pThread, void *Data)
{
	int Arg = *((int*)Data);
	TThreadID ThreadID = Thread_GetCurrentThreadId();
	int SleepDelta = 250;
	
#ifdef APPLE
	LOG_DEBUG("slave: starting thread with id %p", ThreadID);
#else
	LOG_DEBUG("slave: starting thread with id %08x", ThreadID);
#endif
	
	while(1)
	{
		if(Thread_Slave_GetCloseEvent(pThread))
			break;
		
		Time_Sleep(SleepDelta);
		Arg++;
		LOG_DEBUG("slave: arg value: %d", Arg);
	}
	
	LOG_DEBUG("slave: stopping thread");
	
	return Arg;
}


int main(void)
{
	void *pThread = NULL;
	int k;
	
	{
		TLog Log;
		
		Log_Reset(&Log);
		Log_SetMode(&Log, LOG_AUTO_FLUSH | LOG_THREAD_SAFE | LOG_SHOW_DATE | LOG_SHOW_FILE | LOG_SHOW_LINE | LOG_SHOW_FUNCTION | LOG_SHOW_THREADID | LOG_SHOW_PID);
		Log_SetFile(&Log, stdout);
		Log_SetPadding(&Log, 100);
		Log_SetDefault(&Log);
	}
	
	// create slave thread
	LOG_DEBUG("master: creating new slave thread");
	k = 0;
	pThread = Thread_Master_Open(ThreadFunction, (void*)&k);
	if(pThread)
	{
		// do something interesting is master thread here...
		Time_Sleep(8765);
		
		// advertise slave thread, wait its termination and cleanup memory
		Thread_Master_SetCloseEvent(pThread);
		Thread_Master_WaitThreadTermination(pThread, 100, 1);
		k = Thread_Master_Close(pThread);
		LOG_DEBUG("master: exit code: %d", k);
	}
	
	return 0;
}
