#ifndef ___INC_LIBSHRED_H___
#define ___INC_LIBSHRED_H___

// JIT detection of visual studio compiler
#ifdef _MSC_VER
//#pragma message ("using msvc win32 compiler")
#define WIN32_MSVC
#define WIN32		// force WIN32, because we may not have been preprocessed by libshred Makefile.inc
#define snprintf _snprintf
#define strdup _strdup
#define popen _popen
#define pclose _pclose
#define inline		// no inline for visual studio, such a shame...
#define strcasecmp _stricmp
#endif

#ifdef WIN32
// mingw flag
#ifdef __MINGW32__
#define WIN32_MINGW
#endif

#define OS_BITS		32
#ifdef _WIN64
#undef OS_BITS
#define OS_BITS		64
#endif
#ifdef __LP64__
#undef OS_BITS
#define OS_BITS		64
#endif

// minimal winnt version
#if !defined(_WIN32_WINNT) || (_WIN32_WINNT < 0x0501)
#undef _WIN32_WINNT
#define _WIN32_WINNT	0x0501
#endif

// always include windows headers here, otherwise it will break with some compiler
#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>
#include <windows.h>
#include <iphlpapi.h>
#include <ws2tcpip.h>
#include <tlhelp32.h>
#include <process.h>
#endif

#ifndef WIN32_MSVC
#include <unistd.h>	// mandatory header for all but msvc
#define SHRED_HANDLE	struct {}
#else
#define SHRED_HANDLE	struct { void * Opaque; }
#endif


#ifdef __cplusplus
extern "C" {
#endif

// always first
#include <libshred/Types.h>
#include <libshred/Macros.h>
#include <libshred/Debug.h>

#include <libshred/Array.h>
#include <libshred/CliParser.h>
#include <libshred/Console.h>
#include <libshred/Dictionary.h>
#include <libshred/FileSystem.h>
#include <libshred/Hash.h>
#include <libshred/INIFile.h>
#include <libshred/IPHelpers.h>
#include <libshred/Log.h>
#include <libshred/MathTools.h>
#include <libshred/NetHelpers.h>
#include <libshred/ProcessTools.h>
#include <libshred/Random.h>
#include <libshred/Runtime.h>
#include <libshred/Sort.h>
#include <libshred/Strings.h>
#include <libshred/System.h>
#include <libshred/Threads.h>
#include <libshred/TimeTools.h>
#include <libshred/TLV.h>

#ifdef __cplusplus
}
#endif

#endif
