#ifndef ___INC_ARRAY_H___
#define ___INC_ARRAY_H___

typedef void (*TArrayDestroyElementProc)(void *Element);
typedef int (*TArrayCompareProc)(void *Element0, void *Element1);

typedef struct
{
	void **	Elements;
	int		szElements;
	int		lElements;
	
	TArrayDestroyElementProc	DestroyCallback;					// can be null
	
}TArray;

TArray *	Array_Create(void);
TArray *	Array_CreateEx(TArrayDestroyElementProc Callback);
void		Array_Destroy(TArray *Array);

void		Array_Clear(TArray *Array);
void		Array_Add(TArray *Array, void *Element);				// = append
void		Array_Insert(TArray *Array, void *Element, int Index);
void		Array_DeleteAt(TArray *Array, int Index);
void		Array_Delete(TArray *Array, void *Element);

#define Array_GetAt(Array,Index)	(Array->Elements[Index])
#define Array_Count(Array)			(Array->lElements)

// sort using qsort
void		Array_Sort(TArray *Array, TArrayCompareProc CompareCallback);

#endif
