#ifndef ___INC_FILE_SYSTEM_H___
#define ___INC_FILE_SYSTEM_H___

int		FileSystem_ReadFileFirstLine(char *Filename, char *Line, int szLine);
int		FileSystem_ReadTextFile(char *Filename, char ***pLines, int *plLines);

int		FileSystem_FileToBuffer(char *Filename, uint8 *Buffer, int *pszBuffer);
int		FileSystem_BufferToFile(uint8 *Buffer, int szBuffer, char *Filename);

int		FileSystem_FileExists(char *Path);
int		FileSystem_FolderExists(char *Path);

int		FileSystem_RealPath(char *Path, char *ResolvedPath, int *pszResolvedPath);
char *	FileSystem_RealPathEx(char *Path, char *RelativePathRoot, char *TmpBuf, int *pszTmpBuf, int IsFile);
int		FileSystem_SplitDirFileName(char *Path, char *Dirname, int *pszDirname, char *Filename, int *pszFilename);	// split Path into directory and filename
#define FileSystem_GetDirName(p, d, psd)	FileSystem_SplitDirFileName(p, d, psd, NULL, NULL)
#define FileSystem_GetBaseName(p, b, psb)	FileSystem_SplitDirFileName(p, NULL, NULL, b, psb)

int64	FileSystem_FileSize(char *Filename);

int		FileSystem_FileDelete(char *Filename);
int		FileSystem_FileCopy(char *FilenameSrc, char *FilenameDst);
int		FileSystem_FileMove(char *FilenameSrc, char *FilenameDst);

// returns the lenght of the temporary path written in Path, 0 otherwise
int		FileSystem_GetTempPath(char *Path, int szPath);
int		FileSystem_GetTempFilename(char *Filename, int szFilename, char *Prefix);

int		FileSystem_GetFilesInDir(char *BasePath, char *MatchString, char ***pFiles, int *plFiles);

int		FileSystem_ChangeDir(char *Path);

#endif
