#ifndef ___INC_HASH_H___
#define ___INC_HASH_H___

/* 32 bits hash */
uint32	Hash_CRC32(uint8 *Key, int lKey);
uint32	Hash_SQLITE(uint8 *Key, int lKey);
uint32	Hash_FNV32(uint8 *Key, int lKey);

/* 128 bits hash */
#define MD5_DIGEST_SIZE		16
#define MD5_DIGEST_STRING_SIZE	((MD5_DIGEST_SIZE * 2) + 1)
void *	Hash_MD5_Init(void);
void	Hash_MD5_Update(void *Handle, uint8 *Buffer, int lBuffer);
void	Hash_MD5_Final(void *Handle, uint8 Digest[MD5_DIGEST_SIZE]);
void	Hash_MD5_String(uint8 *Buffer, int lBuffer, char DigestStr[MD5_DIGEST_STRING_SIZE]);

/* 160 bits hash */
#define SHA1_DIGEST_SIZE	20
#define SHA1_DIGEST_STRING_SIZE	((SHA1_DIGEST_SIZE * 2) + 1)
void *	Hash_SHA1_Init(void);
void	Hash_SHA1_Update(void *Handle, uint8 *Buffer, int lBuffer);
void	Hash_SHA1_Final(void *Handle, uint8 Digest[SHA1_DIGEST_SIZE]);
void	Hash_SHA1_String(uint8 *Buffer, int lBuffer, char DigestStr[SHA1_DIGEST_STRING_SIZE]);

void	Hash_DigestToStringEx(uint8 *RawDigest, int szRawDigest, char *StringDigest);
#define Hash_MD5_DigestToString(rd,sd)		Hash_DigestToStringEx(rd, MD5_DIGEST_SIZE, sd)
#define Hash_SHA1_DigestToString(rd,sd)		Hash_DigestToStringEx(rd, SHA1_DIGEST_SIZE, sd)
#define Hash_UINT32_DigestToString(rd,sd)	sprintf(sd, "%08x", rd)


/* hash table */

// x64 / MacOSX headache: use the right cast according to compiler spec
#ifdef APPLE
#define OFFSET_OF(structure,field)	((uint32)(unsigned long)&(((structure*)0)->field))
#else
#if OS_BITS == 64
#define OFFSET_OF(structure,field)	((uint32)(uint64)&(((structure*)0)->field))
#else
#define OFFSET_OF(structure,field)	((uint32)&(((structure*)0)->field))
#endif
#endif


typedef uint32 (*THash_Callback)(uint8 *Key, int lKey);

typedef struct
{
	void **	Data;
	int		nData;
	
}THashTableRow;

typedef struct
{
	int				Modulus;
	int				StringOffset;
	int				lStringOffset;
	int				nItems;
	THash_Callback	Callback;
	
	// cursor to walk through data
	int				iCursor;
	int				jCursor;
	
	THashTableRow *	Hash;	/* number of elements = Modulus */
	
}THashTable;

typedef void (*HashTable_DestroyDataCallback)(void *Data);


THashTable *	HashTable_Create(int Modulus, int StringOffset, int lStringOffset, THash_Callback Callback);
void			HashTable_Destroy(THashTable *HashTable, HashTable_DestroyDataCallback DestroyCallback);

#define			HashTable_Count(u)	((u)->nItems)
int				HashTable_Add(THashTable *HashTable, void *Data);
int				HashTable_Delete(THashTable *HashTable, char *String, int lString, HashTable_DestroyDataCallback DestroyCallback);
void *			HashTable_Search(THashTable *HashTable, char *String, int lString);

void *			HashTable_First(THashTable *HashTable);
void *			HashTable_Next(THashTable *HashTable);

void			HashTable_Dump(THashTable *HashTable);
void			HashTable_Statistics(THashTable *HashTable);

#endif
