#ifndef ___INC_INI_FILE_H___
#define ___INC_INI_FILE_H___

typedef struct
{
	char *	Name;
	char *	Value;
	
}TINIAttribute;

typedef struct
{
	char *			Name;
	int				nAttributes;
	TINIAttribute **	Attributes;
	
}TINISection;

typedef struct
{
	int			nSections;
	TINISection **Sections;
	
}TINIFile;


TINIFile *	INIFile_Create(void);
void		INIFile_Destroy(TINIFile *INIFile);
TINIFile *	INIFile_ReadFromMemoryEx(char *Memory, char Separator);
TINIFile *	INIFile_ReadEx(char *Filename, char Separator);
#define		INIFile_ReadFromMemory(m)	INIFile_ReadFromMemoryEx(m, 0)
#define		INIFile_Read(m)				INIFile_ReadEx(m, 0)
int			INIFile_Write(TINIFile *INIFile, char *Filename);

void		INIFile_Dump(TINIFile *INIFile);

/*
	INIFile_Search:
		if Section is NULL, search on all section
		if Section is "", search on the first (unnammed) section
*/
char *		INIFile_Search(TINIFile *INIFile, char *Section, char *Attribute);
#define		INIFile_Get(ctx, s, a) INIFile_Search(ctx, s, a)

/*
	INIFile_SearchEx:
		use INIFile_SearchEx(..., n) to get the n-th occurency of any attribute
*/
char *		INIFile_SearchEx(TINIFile *INIFile, char *Section, char *Attribute, int ID);

/* INIFile_Set/Unset works only on the first occurency of an attribute */
int			INIFile_Set(TINIFile *INIFile, char *Section, char *Attribute, char *Value);
void		INIFile_Unset(TINIFile *INIFile, char *Section, char *Attribute);


/*
	INIFile_Translate:
		do variable translation
		assignation:	$MyVar = some string
		usage:			Param = ${MyVar}-v1.0
*/
int			INIFile_Translate(TINIFile *INIFile);


TINISection *INIFile_FindSection(TINIFile *INIFile, char *Name);
char *		INIFile_FindInSection(TINISection *pSection, char *Attribute);

#endif
