#ifndef ___INC_LOG_H___
#define ___INC_LOG_H___

#include <stdio.h>
#include <stdarg.h>

#include <libshred.h>

/* comment to compile with debugging info */
//#define DEBUG_LOG

/*
	macros:
	LOG is always defined
	LOG_DEBUG is used only in debugging compilation
*/
#define LOG_LEVEL_DEBUG		0
#define LOG_LEVEL_INFO		1
#define LOG_LEVEL_ERROR		((uint32)(-1))

#define LOG(log, lvl, ...)	Log_Print(log, lvl, __FILE__, __LINE__, (char*)__FUNCTION__, __VA_ARGS__)
#define LOG_DEBUG(...)		LOG(NULL, LOG_LEVEL_DEBUG, __VA_ARGS__)
#define LOG_INFO(...)		LOG(NULL, LOG_LEVEL_INFO, __VA_ARGS__)
#define LOG_ERROR(...)		LOG(NULL, LOG_LEVEL_ERROR, __VA_ARGS__)

#ifndef LOG_TRACE
#ifdef __cplusplus
#define LOG_TRACE()			LOG_DEBUG("TRACE: %s", __PRETTY_FUNCTION__)
#else
#define LOG_TRACE()			LOG_DEBUG("TRACE: %s()", __FUNCTION__)
#endif
#endif

typedef void TLogCallback(char *Line, void *Data);

typedef struct
{
	uint32	Mode;
	
	// file data
	char *	Filename;
	FILE *	File;
	
	// presentation options
	int		Padding;
	int		Disabled;
	uint32	Mask;
	
	// rotate
	int		nLines;
	int		nLinesMax;	// >= 100
	int		szOut;
	int		szOutMax;	// >= 1kB
	int		nRotateFile;
	
	// callback
	TLogCallback *ClbkProc;
	void *	ClbkData;
	
	// internal, do not touch
	void *	Mutex;
	
}TLog;


// flags for Log_SetMode
#define LOG_NONE			0x00000000
#define LOG_AUTO_FLUSH		0x00000001		// flush each line
#define LOG_THREAD_SAFE		0x00000002
#define LOG_NO_COLOR		0x00000004

#define LOG_SHOW_DATE		0x00000100	// show precise date
#define LOG_SHOW_PID		0x00000200	// show pid
#define LOG_SHOW_THREADID	0x00000400	// show thread id
#define LOG_SHOW_FILE		0x00000800
#define LOG_SHOW_LINE		0x00001000
#define LOG_SHOW_FUNCTION	0x00002000
#define LOG_SHOW_ALL		(LOG_SHOW_DATE|LOG_SHOW_PID|LOG_SHOW_THREADID|LOG_SHOW_FILE|LOG_SHOW_LINE|LOG_SHOW_FUNCTION)


void	Log_SetDefault(TLog *Log);
TLog *	Log_GetDefault(void);
void	Log_EnableDefault(int Enable);

void	Log_Reset(TLog *Log);
#define	Log_SetMode(mLog, mMode)			((mLog)->Mode = (mMode))
int		Log_SetFile(TLog *Log, FILE *File);

#define Log_SetPadding(mLog, mPadding)		((mLog)->Padding = (mPadding))
#define Log_Enable(mLog, mEnable)			((mLog)->Disabled = !(mEnable))
#define Log_SetLinesMax(mLog, mMaxLines)	((mLog)->nLinesMax = (mMaxLines))

void	Log_SetCallback(TLog *Log, TLogCallback *Proc, void *Data);

#ifndef WIN32_MSVC
int		Log_Print(TLog *Log, int Level, char *Filename, int iLine, char *Function, char *Format, ...) __attribute__ ((format(printf, 6, 7)));
#else
int		Log_Print(TLog *Log, int Level, char *Filename, int iLine, char *Function, char *Format, ...);
#endif

#endif
