#ifndef ___INC_STRINGS_H___
#define ___INC_STRINGS_H___

#include <stdarg.h>

/* Macros */
#define String_SafeReplace(sout,sin)	\
do						\
{						\
	if(sout)			\
		free(sout);		\
	sout = NULL;		\
	if(sin)				\
		sout = strdup(sin);	\
}while(0)

#define String_SafeFree(s)	\
do				\
{				\
	if(s)		\
		free(s);\
	s = NULL;	\
}while(0)

#define String_SafeMove(sin,sout) \
do \
{ \
	if(sout) \
	{ \
		free(sout); \
		sout = NULL; \
	} \
	if(sin) \
	{ \
		sout = sin; \
		sin = NULL; \
	} \
}while(0)

#define String_SafeNull(s)	((s) ? (s) : "")

#define String_IsEmpty(s)	((!s)?1:((!(*(s)))?1:0))

#define String_PrintString(str, size, ...)		(snprintf((str), (size < 0) ? (0) : (size), __VA_ARGS__))


/* base 64 */
int		String_Base64EncodeSize(int Size);
int		String_Base64EncodeInputSize(int OutSize);
int		String_Base64Encode(uint8 *String, int lString, char **pBufferOut, int *pszBufferOut);
int		String_Base64Decode(char *String, int lString, uint8 **pBufferOut, int *pszBufferOut);

/* hex conversion */
int		String_HexToBuffer(char *HexString, int lHexString, uint8 **pBuffer, int *plBuffer);	// call it with *pBuffer = NULL to automatically allocated buffer
int		String_BufferToHex(uint8 *Buffer, int lBuffer, char **pHexString, int *plHexString);

/* url */
int		String_URLEncode(char *From, char *To, int Length);
int		String_URLDecode(char *From, char *To, int Length);

/* split */
int		String_Split(char *String, char Separator, char ***pArray, int *plArray);

/* append */
typedef struct
{
	int		MaxSize;
	char *	Buffer;
	int		szBuffer;
	int		lBuffer;
	
}TAppendInfo;

void	String_Append_Init(TAppendInfo *Info, int MaxSize);
void	String_Append_String(TAppendInfo *Info, char *String);
void	String_Append_StringArgs(TAppendInfo *Info, char *Format, ...);
char *	String_Append_Finalize(TAppendInfo *Info, int *pLength);

/* array of strings */
void	StringArray_Init(char ***pArray, int *plArray);
void	StringArray_Free(char ***pArray, int *plArray);
void	StringArray_AppendString(char ***pArray, int *plArray, char *String);
void	StringArray_AppendStringArgs(char ***pArray, int *plArray, char *Format, ...);

/* check */
// set lString to -1 to test the whole string
int		String_IsDNSNameEx(char *String, int lString);
#define String_IsDNSName(s)		String_IsDNSNameEx(s, -1)
int		String_IsAlphaNumEx(char *String, int lString);
#define String_IsAlphaNum(s)	String_IsAlphaNumEx(s, -1)
int		String_IsAlphaEx(char *String, int lString);
#define String_IsAlpha(s)		String_IsAlphaEx(s, -1)
int		String_IsDigitEx(char *String, int lString);
#define String_IsDigit(s)		String_IsDigitEx(s, -1)

int		String_CheckIP(char *String);
int		String_CheckFQDN(char *String);

int		String_IsNumber(char *String);
int		String_GetNumber(char *String, int *Number, int *nDigits);
char *	String_IntToString(int n, char *Buffer, int szBuffer);	// you must not use Buffer, as the number is right aligned

/* search */
uint8 * String_BinarySearch(uint8 *Buffer, int lBuffer, uint8 *Pattern, int lPattern);
#define String_Search(string,needle)	((char*)String_BinarySearch(((uint8*)string), strlen((char*)string), ((uint8*)needle), -1))
int		String_Match(char *String, char *Wildcard);
int		String_IndexOf(char *String, char Character);
int		String_LastIndexOf(char *String, char Character);
#define String_GetKeyValue(s, pk, pv)	String_GetKeyValueEx(s, pk, pv, '=')
int		String_GetKeyValueEx(char *String, char **pKey, char **pValue, char Separator);

/* clean */
/* MaxLength = 0 : automatic trim */
int		String_TrimEx(char *Line, int MaxLength);
#define String_Trim(Line)	String_TrimEx(Line, 0)

/* conversion */
void	String_ToLower(char *String);
void	String_ToUpper(char *String);

/* comparison */
int		String_Equal(char *String1, char *String2);	// compare pointers and values
int		String_Compare_Natural(char *String1, char *String2, int CaseSensitive);
#define String_StartsWith(s, n)		String_StartsWithEx(s, n, NULL)
int		String_StartsWithEx(char *String, char *Needle, char **pTrail);
int		String_EndsWith(char *String, char *Needle);

/* copy */
// if lString=-1, full duplicate, else truncated duplicate
char *	String_DuplicateEx(char *String, int lString);
#define String_Duplicate(s)	String_DuplicateEx(s, -1)

int		String_CopyEx(char *In, char *Out, int szOut, int lCopy);
#define String_Copy(In, Out, szOut) String_CopyEx(In, Out, szOut, -1)

/* format */
// lString is required
int		String_IsBinary(char *String, int lString);

#define ESCAPE_OPT_NONE			0
#define ESCAPE_OPT_ALL			1
#define ESCAPE_OPT_NOESCAPECHAR	2	// valid only with ESCAPE_OPT_ALL
int		String_Escape(uint8 *In, int lIn, char *Out, int lOut, int Options);

#endif
