#ifndef ___INC_TLV_H___
#define ___INC_TLV_H___


#define TLV_HEAD_SIZE	(sizeof(uint32) + sizeof(uint32))

// use this macro like this: TLV_FOURCC('H', 'E', 'L', 'O')
#define TLV_FOURCC(a, b, c, d)	( ((uint32)d) | ( ((uint32)c) << 8 ) | ( ((uint32)b) << 16 ) | ( ((uint32)a) << 24 ) )

#define TLV_ID_NONE	((uint32)0x00000000)
#define TLV_ID_ANY	((uint32)0xffffffff)


typedef int (*THasChildTLVClbk)(uint32 ID);
void TLV_Dump(uint8 *Buffer, int szBuffer, THasChildTLVClbk HasChildTLV);

// check functions
int TLV_IsComplete(uint8 *Buffer, int szBuffer, int *pSize);
int TLV_GetLength(uint8 *Buffer, int szBuffer);					// works with at least TLV_HEAD_SIZE bytes of data

void TLV_Buffer_Prepare(uint8 **pBuffer, int *pszBuffer);
void TLV_Buffer_Cleanup(uint8 **pBuffer, int *pszBuffer);

// read functions
int TLV_Extract_Buffer(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint8 **pChildBuffer, int *pszChildBuffer);	// no free() needed
int TLV_Extract_UInt8(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint8 *pByte);
int TLV_Extract_UInt16(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint16 *pUInt16);
int TLV_Extract_UInt32(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint32 *pUInt32);
int TLV_Extract_UInt64(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint64 *pUInt64);
int TLV_Extract_String(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, char **pString);	// string is allocated, must call free()
int TLV_Extract_RefCount(uint8 *Buffer, int szBuffer, uint32 ID);

// simplified extraction
int TLV_Extract_UInt32AsUInt8(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint32 *pUInt32, uint32 DefaultValue);
int TLV_Extract_UInt32AsUInt16(uint8 *Buffer, int szBuffer, uint32 ID, int iRefCount, uint32 *pUInt32, uint32 DefaultValue);

// write functions
void TLV_Append_Buffer(uint8 **pBuffer, int *pszBuffer, uint32 ID, uint8 *Buffer, int szBuffer);
void TLV_Append_UInt8(uint8 **pBuffer, int *pszBuffer, uint32 ID, uint8 Byte);
void TLV_Append_UInt16(uint8 **pBuffer, int *pszBuffer, uint32 ID, uint16 UInt16);
void TLV_Append_UInt32(uint8 **pBuffer, int *pszBuffer, uint32 ID, uint32 UInt32);
void TLV_Append_UInt64(uint8 **pBuffer, int *pszBuffer, uint32 ID, uint64 UInt64);
void TLV_Append_String(uint8 **pBuffer, int *pszBuffer, uint32 ID, char *String);

//void TLV_Dump(void *Handle);

// stream read/write functions
// function should return 1 on success, 0 on failure (includes connection closed)
typedef int (*TTLVStreamReadWriteBlock)(void *Handle, uint8 *Buffer, int szBuffer);

int TLV_Read_Stream(TTLVStreamReadWriteBlock ReadProc, void *ReadHandle, uint32 ID, uint32 *pID, uint8 **pBuffer, int *pszBuffer);
int TLV_Write_Stream(TTLVStreamReadWriteBlock WriteProc, void *WriteHandle, uint32 ID, uint8 *Buffer, int szBuffer);

#endif
