#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <math.h>

#include <libshred.h>


/*
	For more information, see http://www.utm.edu/research/primes/glossary/WheelFactorization.html.
*/

static uint8 _WheelTab[] = {
	 1, 2, 2, 4, 2, 4, 2, 4, 6, 2,
	 6, 4, 2, 4, 6, 6, 2, 6, 4, 2,
	 6, 4, 6, 8, 4, 2, 4, 2, 4,14,
	 4, 6, 2,10, 2, 6, 6, 4, 2, 4,
	 6, 2,10, 2, 4, 2,12,10, 2, 4,
	 2, 4, 6, 2, 6, 4, 6, 6, 6, 2,
	 6, 4, 2, 6, 4, 6, 8, 4, 2, 4,
	 6, 8, 6,10, 2, 4, 6, 2, 6, 6,
	 4, 2, 4, 6, 2, 6, 4, 2, 6,10,
	 2,10, 2, 4, 2, 4, 6, 8, 4, 2,
	 4,12, 2, 6, 4, 2, 6, 4, 6,12,
	 2, 4, 2, 4, 8, 6, 4, 6, 2, 4,
	 6, 2, 6,10, 2, 4, 6, 2, 6, 4,
	 2, 4, 2,10, 2,10, 2, 4, 6, 6,
	 2, 6, 6, 4, 6, 6, 2, 6, 4, 2,
	 6, 4, 6, 8, 4, 2, 6, 4, 8, 6,
	 4, 6, 2, 4, 6, 8, 6, 4, 2,10,
	 2, 6, 4, 2, 4, 2,10, 2,10, 2,
	 4, 2, 4, 8, 6, 4, 2, 4, 6, 6,
	 2, 6, 4, 8, 4, 6, 8, 4, 2, 4,
	 2, 4, 8, 6, 4, 6, 6, 6, 2, 6,
	 6, 4, 2, 4, 6, 2, 6, 4, 2, 4,
	 2,10, 2,10, 2, 6, 4, 6, 2, 6,
	 4, 2, 4, 6, 6, 8, 4, 2, 6,10,
	 8, 4, 2, 4, 2, 4, 8,10, 6, 2,
	 4, 8, 6, 6, 4, 2, 4, 6, 2, 6,
	 4, 6, 2,10, 2,10, 2, 4, 2, 4,
	 6, 2, 6, 4, 2, 4, 6, 6, 2, 6,
	 6, 6, 4, 6, 8, 4, 2, 4, 2, 4,
	 8, 6, 4, 8, 4, 6, 2, 6, 6, 4,
	 2, 4, 6, 8, 4, 2, 4, 2,10, 2,
	10, 2, 4, 2, 4, 6, 2,10, 2, 4,
	 6, 8, 6, 4, 2, 6, 4, 6, 8, 4,
	 6, 2, 4, 8, 6, 4, 6, 2, 4, 6,
	 2, 6, 6, 4, 6, 6, 2, 6, 6, 4,
	 2,10, 2,10, 2, 4, 2, 4, 6, 2,
	 6, 4, 2,10, 6, 2, 6, 4, 2, 6,
	 4, 6, 8, 4, 2, 4, 2,12, 6, 4,
	 6, 2, 4, 6, 2,12, 4, 2, 4, 8,
	 6, 4, 2, 4, 2,10, 2,10, 6, 2,
	 4, 6, 2, 6, 4, 2, 4, 6, 6, 2,
	 6, 4, 2,10, 6, 8, 6, 4, 2, 4,
	 8, 6, 4, 6, 2, 4, 6, 2, 6, 6,
	 6, 4, 6, 2, 6, 4, 2, 4, 2,10,
	12, 2, 4, 2,10, 2, 6, 4, 2, 4,
	 6, 6, 2,10, 2, 6, 4,14, 4, 2,
	 4, 2, 4, 8, 6, 4, 6, 2, 4, 6,
	 2, 6, 6, 4, 2, 4, 6, 2, 6, 4,
	 2, 4,12, 2,12
};

#define WHEEL_SIZE 5
#define WHEEL_START (_WheelTab + WHEEL_SIZE)
#define WHEEL_END (_WheelTab + (sizeof _WheelTab / sizeof _WheelTab[0]))


// should see sieve-algorithm
int Math_IsPrime_32(uint32 n)
{
	uint32 n0 = n, d, q;
	int nFactors = 0;
	uint8 *w = _WheelTab;
	
	if(n <= 1)
		return 0;
	
	d = 2;
	do
	{
		q = n0 / d;
		while(n0 == q * d)
		{
			nFactors++;
			if(nFactors >= 2)
				return 0;
			
			n0 = q;
			q = n0 / d;
		}
		d += *(w++);
		if(w == WHEEL_END)
			w = WHEEL_START;
	}
	while(d <= q);
	
	if(n0 != 1 || n == 1)
	{
		nFactors++;
		
		if(nFactors >= 2)
			return 0;
	}
	
	if(nFactors >= 2)
		return 0;
	
	return 1;
}


int Math_IsPrime_64(uint64 n)
{
	uint64 n0 = n, d, q;
	int nFactors = 0;
	uint8 *w = _WheelTab;
	
	if(n <= 1)
		return 0;
	
	d = 2;
	do
	{
		q = n0 / d;
		while(n0 == q * d)
		{
			nFactors++;
			if(nFactors >= 2)
				return 0;
			
			n0 = q;
			q = n0 / d;
		}
		d += *(w++);
		if(w == WHEEL_END)
			w = WHEEL_START;
	}
	while(d <= q);
	
	if(n0 != 1 || n == 1)
	{
		nFactors++;
		
		if(nFactors >= 2)
			return 0;
	}
	
	if(nFactors >= 2)
		return 0;
	
	return 1;
}


uint32 Math_NextPowerOf2_32(uint32 n)
{
	uint32 Mask = 1u << 31;
	
	while(!(n & Mask) && Mask)
		Mask >>= 1;
	
	if(!Mask)
		return 1;
	
	return Mask << 1;
}


uint64 Math_NextPowerOf2_64(uint64 n)
{
	uint64 Mask = 1llu << 63;
	
	while(!(n & Mask) && Mask)
		Mask >>= 1;
	
	if(!Mask)
		return 1;
	
	return Mask << 1;
}


//	Wilco Dijkstra
#define ITER1(N)				\
	uTry = uRoot + (1 << (N));	\
	if (n >= uTry << (N))		\
	{   n -= uTry << (N);		\
		uRoot |= 2 << (N);		\
	}

uint32 Math_ISqrt_Dijkstra(uint32 n)
{
	uint32 uRoot = 0, uTry;
	
	ITER1(15); ITER1(14); ITER1(13); ITER1(12);
	ITER1(11); ITER1(10); ITER1( 9); ITER1( 8);
	ITER1( 7); ITER1( 6); ITER1( 5); ITER1( 4);
	ITER1( 3); ITER1( 2); ITER1( 1); ITER1( 0);
	
	return uRoot >> 1;
}


uint32 Math_ISqrt_FPU(uint32 n)
{
	return (uint32)floor(sqrt((double)n));
}
